/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.BytesRefArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.enrich.EnrichResultBuilder;

final class EnrichResultBuilderForBytesRef
extends EnrichResultBuilder {
    private final BytesRefArray bytes;
    private BytesRef scratch = new BytesRef();
    private ObjectArray<int[]> cells;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnrichResultBuilderForBytesRef(BlockFactory blockFactory, int channel) {
        super(blockFactory, channel);
        this.cells = blockFactory.bigArrays().newObjectArray(1L);
        BytesRefArray bytes = null;
        try {
            this.bytes = bytes = new BytesRefArray(1L, blockFactory.bigArrays());
        }
        finally {
            if (bytes == null) {
                this.cells.close();
            }
        }
    }

    @Override
    void addInputPage(IntVector positions, Page page) {
        BytesRefBlock block = (BytesRefBlock)page.getBlock(this.channel);
        BytesRef scratch = new BytesRef();
        for (int i = 0; i < positions.getPositionCount(); ++i) {
            int valueCount = block.getValueCount(i);
            if (valueCount == 0) continue;
            int cellPosition = positions.getInt(i);
            this.cells = this.blockFactory.bigArrays().grow(this.cells, (long)(cellPosition + 1));
            int[] oldCell = (int[])this.cells.get((long)cellPosition);
            int[] newCell = this.extendCell(oldCell, valueCount);
            this.cells.set((long)cellPosition, (Object)newCell);
            int dstIndex = oldCell != null ? oldCell.length : 0;
            this.adjustBreaker(RamUsageEstimator.sizeOf((int[])newCell) - (oldCell != null ? RamUsageEstimator.sizeOf((int[])oldCell) : 0L));
            int firstValueIndex = block.getFirstValueIndex(i);
            int bytesOrd = Math.toIntExact(this.bytes.size());
            for (int v = 0; v < valueCount; ++v) {
                scratch = block.getBytesRef(firstValueIndex + v, scratch);
                this.bytes.append(scratch);
                newCell[dstIndex + v] = bytesOrd + v;
            }
        }
    }

    private int[] extendCell(int[] oldCell, int newValueCount) {
        if (oldCell == null) {
            return new int[newValueCount];
        }
        return Arrays.copyOf(oldCell, oldCell.length + newValueCount);
    }

    private int[] combineCell(int[] first, int[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int[] result = new int[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private void appendGroupToBlockBuilder(BytesRefBlock.Builder builder, int[] group) {
        if (group == null) {
            builder.appendNull();
        } else if (group.length == 1) {
            builder.appendBytesRef(this.bytes.get((long)group[0], this.scratch));
        } else {
            builder.beginPositionEntry();
            for (int v : group) {
                builder.appendBytesRef(this.bytes.get((long)v, this.scratch));
            }
            builder.endPositionEntry();
        }
    }

    private int[] getCellOrNull(int position) {
        return (long)position < this.cells.size() ? (int[])this.cells.get((long)position) : null;
    }

    private Block buildWithSelected(IntBlock selected) {
        try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
            block9: for (int i = 0; i < selected.getPositionCount(); ++i) {
                int selectedCount = selected.getValueCount(i);
                switch (selectedCount) {
                    case 0: {
                        builder.appendNull();
                        continue block9;
                    }
                    case 1: {
                        int groupId = selected.getInt(selected.getFirstValueIndex(i));
                        this.appendGroupToBlockBuilder(builder, this.getCellOrNull(groupId));
                        continue block9;
                    }
                    default: {
                        int firstValueIndex = selected.getFirstValueIndex(i);
                        int[] cell = this.getCellOrNull(selected.getInt(firstValueIndex));
                        for (int p = 1; p < selectedCount; ++p) {
                            int groupId = selected.getInt(firstValueIndex + p);
                            cell = this.combineCell(cell, this.getCellOrNull(groupId));
                        }
                        this.appendGroupToBlockBuilder(builder, cell);
                    }
                }
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private Block buildWithSelected(IntVector selected) {
        try (BytesRefBlock.Builder builder = this.blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                this.appendGroupToBlockBuilder(builder, this.getCellOrNull(selected.getInt(i)));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    @Override
    Block build(IntBlock selected) {
        IntVector vector = selected.asVector();
        if (vector != null) {
            return this.buildWithSelected(vector);
        }
        return this.buildWithSelected(selected);
    }

    @Override
    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.bytes, this.cells, () -> super.close()});
    }
}

