/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.analysis.TableInfo;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    protected PreAnalysis doPreAnalyze(LogicalPlan plan) {
        ArrayList<TableInfo> indices = new ArrayList<TableInfo>();
        ArrayList<Enrich> unresolvedEnriches = new ArrayList<Enrich>();
        plan.forEachUp(UnresolvedRelation.class, p -> indices.add(new TableInfo(p.table())));
        plan.forEachUp(Enrich.class, unresolvedEnriches::add);
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis(indices, unresolvedEnriches);
    }

    public static class PreAnalysis {
        public static final PreAnalysis EMPTY = new PreAnalysis(Collections.emptyList(), Collections.emptyList());
        public final List<TableInfo> indices;
        public final List<Enrich> enriches;

        public PreAnalysis(List<TableInfo> indices, List<Enrich> enriches) {
            this.indices = indices;
            this.enriches = enriches;
        }
    }
}

