/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.action;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.Level;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.arrow.ArrowFormat;
import org.elasticsearch.xpack.esql.arrow.ArrowResponse;
import org.elasticsearch.xpack.esql.formatter.TextFormat;
import org.elasticsearch.xpack.esql.plugin.EsqlMediaTypeParser;

public final class EsqlResponseListener
extends RestRefCountedChunkedToXContentListener<EsqlQueryResponse> {
    private static final Logger LOGGER = LogManager.getLogger(EsqlResponseListener.class);
    private static final String HEADER_NAME_TOOK_NANOS = "Took-nanos";
    private final RestChannel channel;
    private final RestRequest restRequest;
    private final MediaType mediaType;
    private final String esqlQuery;
    private final ThreadSafeStopWatch stopWatch = new ThreadSafeStopWatch();

    public EsqlResponseListener(RestChannel channel, RestRequest restRequest, EsqlQueryRequest esqlRequest) {
        super(channel);
        this.channel = channel;
        this.restRequest = restRequest;
        this.esqlQuery = esqlRequest.query();
        this.mediaType = EsqlMediaTypeParser.getResponseMediaType(restRequest, esqlRequest);
        if (this.mediaType != TextFormat.CSV && restRequest.hasParam("delimiter")) {
            String message = String.format(Locale.ROOT, "parameter: [%s] can only be used with the format [%s] for request [%s]", "delimiter", TextFormat.CSV.queryParameter(), restRequest.path());
            throw new IllegalArgumentException(message);
        }
    }

    protected void processResponse(EsqlQueryResponse esqlQueryResponse) throws IOException {
        this.channel.sendResponse(this.buildResponse(esqlQueryResponse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestResponse buildResponse(EsqlQueryResponse esqlResponse) throws IOException {
        boolean success = false;
        Releasable releasable = this.releasableFromResponse((ChunkedToXContent)esqlResponse);
        try {
            RestResponse restResponse;
            MediaType mediaType = this.mediaType;
            if (mediaType instanceof TextFormat) {
                TextFormat format = (TextFormat)mediaType;
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBodyPart)ChunkedRestResponseBodyPart.fromTextChunks((String)format.contentType(this.restRequest), format.format(this.restRequest, esqlResponse)), (Releasable)releasable);
            } else if (this.mediaType == ArrowFormat.INSTANCE) {
                ArrowResponse arrowResponse = new ArrowResponse(esqlResponse.columns().stream().map(c -> new ArrowResponse.Column(c.outputType(), c.name())).toList(), esqlResponse.pages());
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBodyPart)arrowResponse, (Releasable)Releasables.wrap((Releasable[])new Releasable[]{arrowResponse, releasable}));
            } else {
                restResponse = RestResponse.chunked((RestStatus)RestStatus.OK, (ChunkedRestResponseBodyPart)ChunkedRestResponseBodyPart.fromXContent((ChunkedToXContent)esqlResponse, (ToXContent.Params)this.channel.request(), (RestChannel)this.channel), (Releasable)releasable);
            }
            restResponse.addHeader(HEADER_NAME_TOOK_NANOS, Long.toString(this.getTook(esqlResponse, TimeUnit.NANOSECONDS)));
            success = true;
            RestResponse restResponse2 = restResponse;
            return restResponse2;
        }
        finally {
            if (!success) {
                releasable.close();
            }
        }
    }

    private long getTook(EsqlQueryResponse esqlResponse, TimeUnit timeUnit) {
        assert (timeUnit == TimeUnit.NANOSECONDS || timeUnit == TimeUnit.MILLISECONDS) : "Unsupported TimeUnit: " + timeUnit;
        TimeValue tookTime = this.stopWatch.stop();
        if (esqlResponse != null && esqlResponse.getExecutionInfo() != null && esqlResponse.getExecutionInfo().overallTook() != null) {
            tookTime = esqlResponse.getExecutionInfo().overallTook();
        }
        if (timeUnit == TimeUnit.NANOSECONDS) {
            return tookTime.nanos();
        }
        return tookTime.millis();
    }

    public ActionListener<EsqlQueryResponse> wrapWithLogging() {
        ActionListener listener = ActionListener.wrap(arg_0 -> ((EsqlResponseListener)this).onResponse(arg_0), ex -> {
            EsqlResponseListener.logOnFailure(ex);
            this.onFailure((Exception)ex);
        });
        if (!LOGGER.isDebugEnabled()) {
            return listener;
        }
        return ActionListener.wrap(r -> {
            listener.onResponse((Object)r);
            LOGGER.debug("Finished execution of ESQL query.\nQuery string: [{}]\nExecution time: [{}]ms", new Object[]{this.esqlQuery, this.getTook((EsqlQueryResponse)((Object)r), TimeUnit.MILLISECONDS)});
        }, ex -> {
            long timeMillis = this.getTook(null, TimeUnit.MILLISECONDS);
            LOGGER.debug("Failed execution of ESQL query.\nQuery string: [{}]\nExecution time: [{}]ms", new Object[]{this.esqlQuery, timeMillis});
            listener.onFailure(ex);
        });
    }

    static void logOnFailure(Throwable throwable) {
        RestStatus status = ExceptionsHelper.status((Throwable)throwable);
        LOGGER.log(status.getStatus() >= 500 ? Level.WARN : Level.DEBUG, () -> "Request failed with status [" + status + "]: ", throwable);
    }

    private static class ThreadSafeStopWatch {
        private final long startTimeNS = System.nanoTime();
        private long endTimeNS;
        private boolean running = true;

        ThreadSafeStopWatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimeValue stop() {
            ThreadSafeStopWatch threadSafeStopWatch = this;
            synchronized (threadSafeStopWatch) {
                if (this.running) {
                    this.endTimeNS = System.nanoTime();
                    this.running = false;
                }
                return new TimeValue(this.endTimeNS - this.startTimeNS, TimeUnit.NANOSECONDS);
            }
        }
    }
}

