/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory.rounding;

import org.apache.arrow.memory.rounding.RoundingPolicy;
import org.apache.arrow.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SegmentRoundingPolicy
implements RoundingPolicy {
    public static final @UnknownKeyFor @NonNull @Initialized long MIN_SEGMENT_SIZE = 1024L;
    private @UnknownKeyFor @NonNull @Initialized int segmentSize;

    public SegmentRoundingPolicy(@UnknownKeyFor @NonNull @Initialized int segmentSize) {
        Preconditions.checkArgument((long)segmentSize >= 1024L, "The segment size cannot be smaller than %s", 1024L);
        Preconditions.checkArgument((segmentSize & segmentSize - 1) == 0, "The segment size must be a power of 2");
        this.segmentSize = segmentSize;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long getRoundedSize(@UnknownKeyFor @NonNull @Initialized long requestSize) {
        return (requestSize + (long)(this.segmentSize - 1)) / (long)this.segmentSize * (long)this.segmentSize;
    }

    public @UnknownKeyFor @NonNull @Initialized int getSegmentSize() {
        return this.segmentSize;
    }
}

