/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.bucket.timeseries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.aggregations.bucket.timeseries.InternalTimeSeries;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TimeSeriesIdFieldMapper;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class TimeSeriesAggregator
extends BucketsAggregator {
    protected final BytesKeyedBucketOrds bucketOrds;
    private final boolean keyed;
    private final int size;
    private final SortedMap<String, ValuesSource> dimensionValueSources;

    public TimeSeriesAggregator(String name, AggregatorFactories factories, boolean keyed, AggregationContext context, Aggregator parent, CardinalityUpperBound bucketCardinality, Map<String, Object> metadata, int size) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.keyed = keyed;
        this.bucketOrds = BytesKeyedBucketOrds.build((BigArrays)this.bigArrays(), (CardinalityUpperBound)bucketCardinality);
        this.size = size;
        this.dimensionValueSources = new TreeMap<String, ValuesSource>();
        for (MappedFieldType dim : context.subSearchContext().getSearchExecutionContext().dimensionFields()) {
            ValuesSource valueSource = ValuesSourceConfig.resolve((AggregationContext)context, null, (String)dim.name(), null, null, null, null, null).getValuesSource();
            this.dimensionValueSources.put(dim.name(), valueSource);
        }
    }

    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        BytesRef spare = new BytesRef();
        InternalTimeSeries.InternalBucket[][] allBucketsPerOrd = new InternalTimeSeries.InternalBucket[owningBucketOrds.length][];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            ArrayList<InternalTimeSeries.InternalBucket> buckets = new ArrayList<InternalTimeSeries.InternalBucket>();
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                ordsEnum.readValue(spare);
                InternalTimeSeries.InternalBucket bucket2 = new InternalTimeSeries.InternalBucket(BytesRef.deepCopyOf((BytesRef)spare), docCount, null, this.keyed);
                bucket2.bucketOrd = ordsEnum.ord();
                buckets.add(bucket2);
                if (buckets.size() < this.size) continue;
                break;
            }
            buckets.sort(Comparator.comparing(bucket -> bucket.key));
            allBucketsPerOrd[ordIdx] = buckets.toArray(new InternalTimeSeries.InternalBucket[0]);
        }
        this.buildSubAggsForAllBuckets((Object[][])allBucketsPerOrd, b -> b.bucketOrd, (b, a) -> {
            b.aggregations = a;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.buildResult(allBucketsPerOrd[ordIdx]);
        }
        return result;
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalTimeSeries(this.name, List.of(), false, this.metadata());
    }

    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
    }

    protected LeafBucketCollector getLeafCollector(final AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final TreeMap<String, TsidConsumer> dimensionConsumers = new TreeMap<String, TsidConsumer>();
        for (Map.Entry<String, ValuesSource> entry : this.dimensionValueSources.entrySet()) {
            SortedBinaryDocValues docValues;
            String fieldName = entry.getKey();
            ValuesSource valuesSource = entry.getValue();
            if (valuesSource instanceof ValuesSource.Numeric) {
                ValuesSource.Numeric numericVS = (ValuesSource.Numeric)valuesSource;
                docValues = numericVS.longValues(aggCtx.getLeafReaderContext());
                dimensionConsumers.put(entry.getKey(), (arg_0, arg_1) -> TimeSeriesAggregator.lambda$getLeafCollector$3((SortedNumericDocValues)docValues, fieldName, arg_0, arg_1));
                continue;
            }
            docValues = entry.getValue().bytesValues(aggCtx.getLeafReaderContext());
            dimensionConsumers.put(entry.getKey(), (docId, tsidBuilder) -> {
                if (docValues.advanceExact(docId)) {
                    assert (docValues.docValueCount() == 1) : "Dimension field cannot be a multi-valued field";
                    tsidBuilder.addString(fieldName, docValues.nextValue());
                }
            });
        }
        return new LeafBucketCollectorBase(sub, null){
            long currentTsidOrd;
            long currentBucket;
            long currentBucketOrdinal;
            BytesRef currentTsid;
            {
                super(arg0, arg1);
                this.currentTsidOrd = -1L;
                this.currentBucket = -1L;
            }

            public void collect(int doc, long bucket) throws IOException {
                BytesRef tsid;
                if (this.currentBucket == bucket && this.currentTsidOrd == (long)aggCtx.getTsidHashOrd()) {
                    TimeSeriesAggregator.this.collectExistingBucket(sub, doc, this.currentBucketOrdinal);
                    return;
                }
                if (this.currentTsidOrd == (long)aggCtx.getTsidHashOrd()) {
                    tsid = this.currentTsid;
                } else {
                    TimeSeriesIdFieldMapper.TimeSeriesIdBuilder tsidBuilder = new TimeSeriesIdFieldMapper.TimeSeriesIdBuilder(null);
                    for (TsidConsumer consumer : dimensionConsumers.values()) {
                        consumer.accept(doc, tsidBuilder);
                    }
                    this.currentTsid = tsid = tsidBuilder.buildLegacyTsid().toBytesRef();
                }
                long bucketOrdinal = TimeSeriesAggregator.this.bucketOrds.add(bucket, tsid);
                if (bucketOrdinal < 0L) {
                    bucketOrdinal = -1L - bucketOrdinal;
                    TimeSeriesAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                } else {
                    TimeSeriesAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                }
                this.currentBucketOrdinal = bucketOrdinal;
                this.currentTsidOrd = aggCtx.getTsidHashOrd();
                this.currentBucket = bucket;
            }
        };
    }

    InternalTimeSeries buildResult(InternalTimeSeries.InternalBucket[] topBuckets) {
        return new InternalTimeSeries(this.name, List.of(topBuckets), this.keyed, this.metadata());
    }

    private static /* synthetic */ void lambda$getLeafCollector$3(SortedNumericDocValues docValues, String fieldName, int docId, TimeSeriesIdFieldMapper.TimeSeriesIdBuilder tsidBuilder) throws IOException {
        if (docValues.advanceExact(docId)) {
            assert (docValues.docValueCount() == 1) : "Dimension field cannot be a multi-valued field";
            tsidBuilder.addLong(fieldName, docValues.nextValue());
        }
    }

    @FunctionalInterface
    static interface TsidConsumer {
        public void accept(int var1, TimeSeriesIdFieldMapper.TimeSeriesIdBuilder var2) throws IOException;
    }
}

