/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.core.CheckedRunnable;

final class SocketAccess {
    private SocketAccess() {
    }

    public static <T> T doPrivilegedIOException(PrivilegedExceptionAction<T> operation) throws IOException {
        SpecialPermission.check();
        try {
            return AccessController.doPrivileged(operation);
        }
        catch (PrivilegedActionException e) {
            throw SocketAccess.causeAsIOException(e);
        }
    }

    public static void doPrivilegedVoidIOException(CheckedRunnable<IOException> action) throws IOException {
        SpecialPermission.check();
        try {
            AccessController.doPrivileged(() -> {
                action.run();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw SocketAccess.causeAsIOException(e);
        }
    }

    private static IOException causeAsIOException(PrivilegedActionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            IOException ioException = (IOException)cause;
            return ioException;
        }
        if (cause instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)cause;
            throw runtimeException;
        }
        throw new RuntimeException(cause);
    }
}

