/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureTransportAction;
import org.elasticsearch.xpack.core.ccr.CcrConstants;

public class CCRInfoTransportAction
extends XPackInfoFeatureTransportAction {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public CCRInfoTransportAction(TransportService transportService, ActionFilters actionFilters, Settings settings, XPackLicenseState licenseState) {
        super(XPackInfoFeatureAction.CCR.name(), transportService, actionFilters);
        this.enabled = (Boolean)XPackSettings.CCR_ENABLED_SETTING.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "ccr";
    }

    public boolean available() {
        return CcrConstants.CCR_FEATURE.checkWithoutTracking(this.licenseState);
    }

    public boolean enabled() {
        return this.enabled;
    }

    public static class Usage
    extends XPackFeatureSet.Usage {
        private final int numberOfFollowerIndices;
        private final int numberOfAutoFollowPatterns;
        private final Long lastFollowTimeInMillis;

        public Usage(boolean available, boolean enabled, int numberOfFollowerIndices, int numberOfAutoFollowPatterns, Long lastFollowTimeInMillis) {
            super("ccr", available, enabled);
            this.numberOfFollowerIndices = numberOfFollowerIndices;
            this.numberOfAutoFollowPatterns = numberOfAutoFollowPatterns;
            this.lastFollowTimeInMillis = lastFollowTimeInMillis;
        }

        public Usage(StreamInput in) throws IOException {
            super(in);
            this.numberOfFollowerIndices = in.readVInt();
            this.numberOfAutoFollowPatterns = in.readVInt();
            this.lastFollowTimeInMillis = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_7_0_0;
        }

        public int getNumberOfFollowerIndices() {
            return this.numberOfFollowerIndices;
        }

        public int getNumberOfAutoFollowPatterns() {
            return this.numberOfAutoFollowPatterns;
        }

        public Long getLastFollowTimeInMillis() {
            return this.lastFollowTimeInMillis;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.numberOfFollowerIndices);
            out.writeVInt(this.numberOfAutoFollowPatterns);
            if (this.lastFollowTimeInMillis != null) {
                out.writeBoolean(true);
                out.writeVLong(this.lastFollowTimeInMillis.longValue());
            } else {
                out.writeBoolean(false);
            }
        }

        protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            super.innerXContent(builder, params);
            builder.field("follower_indices_count", this.numberOfFollowerIndices);
            builder.field("auto_follow_patterns_count", this.numberOfAutoFollowPatterns);
            if (this.lastFollowTimeInMillis != null) {
                builder.field("last_follow_time_in_millis", this.lastFollowTimeInMillis);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Usage usage = (Usage)((Object)o);
            return this.numberOfFollowerIndices == usage.numberOfFollowerIndices && this.numberOfAutoFollowPatterns == usage.numberOfAutoFollowPatterns && Objects.equals(this.lastFollowTimeInMillis, usage.lastFollowTimeInMillis);
        }

        public int hashCode() {
            return Objects.hash(this.numberOfFollowerIndices, this.numberOfAutoFollowPatterns, this.lastFollowTimeInMillis);
        }
    }
}

