/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.SearchApplicationIndexService;
import org.elasticsearch.xpack.application.search.action.PutSearchApplicationAction;

public class TransportPutSearchApplicationAction
extends HandledTransportAction<PutSearchApplicationAction.Request, PutSearchApplicationAction.Response> {
    protected final SearchApplicationIndexService systemIndexService;

    @Inject
    public TransportPutSearchApplicationAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, BigArrays bigArrays) {
        super("cluster:admin/xpack/application/search_application/put", transportService, actionFilters, PutSearchApplicationAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.systemIndexService = new SearchApplicationIndexService(client, clusterService, namedWriteableRegistry, bigArrays);
    }

    protected void doExecute(Task task, PutSearchApplicationAction.Request request, ActionListener<PutSearchApplicationAction.Response> listener) {
        SearchApplication app = request.getSearchApplication();
        boolean create = request.create();
        if (!app.hasStoredTemplate()) {
            HeaderWarning.addWarning((String)"Using default search application template which is subject to change. We recommend storing a template to avoid breaking changes.", (Object[])new Object[0]);
        }
        this.systemIndexService.putSearchApplication(app, create, (ActionListener<DocWriteResponse>)listener.map(r -> new PutSearchApplicationAction.Response(r.getResult())));
    }
}

