/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;

public class DeleteConnectorAction {
    public static final String NAME = "indices:data/write/xpack/connector/delete";
    public static final ActionType<AcknowledgedResponse> INSTANCE = new ActionType("indices:data/write/xpack/connector/delete");

    private DeleteConnectorAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        private final String connectorId;
        private final boolean deleteSyncJobs;
        private static final ParseField CONNECTOR_ID_FIELD = new ParseField("connector_id", new String[0]);
        private static final ParseField DELETE_SYNC_JOB_FIELD = new ParseField("delete_sync_jobs", new String[0]);
        private static final ConstructingObjectParser<Request, Void> PARSER = new ConstructingObjectParser("delete_connector_request", false, p -> new Request((String)p[0], (Boolean)p[1]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.deleteSyncJobs = in.readBoolean();
        }

        public Request(String connectorId, boolean deleteSyncJobs) {
            this.connectorId = connectorId;
            this.deleteSyncJobs = deleteSyncJobs;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.connectorId)) {
                validationException = ValidateActions.addValidationError((String)"connector_id missing", validationException);
            }
            return validationException;
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public boolean shouldDeleteSyncJobs() {
            return this.deleteSyncJobs;
        }

        @Override
        public String[] indices() {
            return new String[]{".elastic-connectors-sync-jobs-v1", ".elastic-connectors-v1"};
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeBoolean(this.deleteSyncJobs);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return this.deleteSyncJobs == request.deleteSyncJobs && Objects.equals(this.connectorId, request.connectorId);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.deleteSyncJobs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CONNECTOR_ID_FIELD.getPreferredName(), this.connectorId);
            builder.field(DELETE_SYNC_JOB_FIELD.getPreferredName(), this.deleteSyncJobs);
            builder.endObject();
            return builder;
        }

        public static Request parse(XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, null));
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CONNECTOR_ID_FIELD);
            PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), DELETE_SYNC_JOB_FIELD);
        }
    }
}

