/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.metrics.AbstractHistoBackedTDigestPercentilesAggregator;

public class HistoBackedTDigestPercentilesAggregator
extends AbstractHistoBackedTDigestPercentilesAggregator {
    public HistoBackedTDigestPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] percents, double compression, TDigestExecutionHint executionHint, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, percents, compression, executionHint, keyed, formatter, metadata);
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentiles(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.quantile(Double.parseDouble(name) / 100.0);
    }

    public InternalAggregation buildEmptyAggregation() {
        TDigestState state = TDigestState.createWithoutCircuitBreaking((double)this.compression, (TDigestExecutionHint)this.executionHint);
        return new InternalTDigestPercentiles(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }
}

