/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.action.AbstractHandlerDelegatingProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.SignatureValidationConfiguration;
import org.opensaml.xmlsec.SignatureValidationParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.messaging.impl.PopulateSignatureValidationParametersHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateSignatureValidationParameters
extends AbstractHandlerDelegatingProfileAction<PopulateSignatureValidationParametersHandler> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSignatureValidationParameters.class);
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class, true).compose((Function)new InboundMessageContextLookup());
    @NonnullAfterInit
    private Function<ProfileRequestContext, List<SignatureValidationConfiguration>> configurationLookupStrategy;
    @NonnullAfterInit
    private SignatureValidationParametersResolver resolver;

    public PopulateSignatureValidationParameters() {
        super(PopulateSignatureValidationParametersHandler.class, (ContextDataLookupFunction)new InboundMessageContextLookup());
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParametersContext lookup strategy cannot be null");
    }

    public void setConfigurationLookupStrategy(@Nonnull Function<ProfileRequestContext, List<SignatureValidationConfiguration>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.configurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SignatureValidationConfiguration lookup strategy cannot be null");
    }

    public void setSignatureValidationParametersResolver(@Nonnull SignatureValidationParametersResolver newResolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolver = (SignatureValidationParametersResolver)Constraint.isNotNull((Object)newResolver, (String)"SignatureValidationParametersResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolver == null) {
            throw new ComponentInitializationException("SignatureValidationParametersResolver cannot be null");
        }
        if (this.configurationLookupStrategy == null) {
            this.configurationLookupStrategy = new Function<ProfileRequestContext, List<SignatureValidationConfiguration>>(){

                @Override
                public List<SignatureValidationConfiguration> apply(ProfileRequestContext input) {
                    return Collections.singletonList(SecurityConfigurationSupport.getGlobalSignatureValidationConfiguration());
                }
            };
        }
        PopulateSignatureValidationParametersHandler delegate = (PopulateSignatureValidationParametersHandler)this.getDelegate();
        delegate.setSignatureValidationParametersResolver(this.resolver);
        delegate.setConfigurationLookupStrategy(this.adapt(this.configurationLookupStrategy));
        delegate.setSecurityParametersContextLookupStrategy(this.adapt(this.securityParametersContextLookupStrategy));
        delegate.initialize();
    }
}

