/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class CrossClusterApiKeyRoleDescriptorBuilder {
    public static final String[] CCS_CLUSTER_PRIVILEGE_NAMES = new String[]{"cross_cluster_search", "monitor_enrich"};
    public static final String[] CCR_CLUSTER_PRIVILEGE_NAMES = new String[]{"cross_cluster_replication"};
    public static final String[] CCS_AND_CCR_CLUSTER_PRIVILEGE_NAMES = (String[])Stream.concat(Arrays.stream(CCS_CLUSTER_PRIVILEGE_NAMES), Arrays.stream(CCR_CLUSTER_PRIVILEGE_NAMES)).toArray(String[]::new);
    public static final String[] CCS_INDICES_PRIVILEGE_NAMES = new String[]{"read", "read_cross_cluster", "view_index_metadata"};
    public static final String[] CCR_INDICES_PRIVILEGE_NAMES = new String[]{"cross_cluster_replication", "cross_cluster_replication_internal"};
    public static final String ROLE_DESCRIPTOR_NAME = "cross_cluster";
    public static final ConstructingObjectParser<CrossClusterApiKeyRoleDescriptorBuilder, Void> PARSER = new ConstructingObjectParser("cross_cluster_api_key_request_access", false, (args, v) -> new CrossClusterApiKeyRoleDescriptorBuilder((List)args[0], (List)args[1]));
    private final List<RoleDescriptor.IndicesPrivileges> search;
    private final List<RoleDescriptor.IndicesPrivileges> replication;

    private CrossClusterApiKeyRoleDescriptorBuilder(List<RoleDescriptor.IndicesPrivileges> search, List<RoleDescriptor.IndicesPrivileges> replication) {
        this.search = search == null ? List.of() : search;
        List<Object> list = this.replication = replication == null ? List.of() : replication;
        assert (this.search.stream().allMatch(p -> Arrays.equals(p.getPrivileges(), CCS_INDICES_PRIVILEGE_NAMES)));
        assert (this.replication.stream().allMatch(p -> Arrays.equals(p.getPrivileges(), CCR_INDICES_PRIVILEGE_NAMES)));
    }

    public RoleDescriptor build() {
        String[] clusterPrivileges;
        if (this.search.isEmpty() && this.replication.isEmpty()) {
            throw new IllegalArgumentException("must specify non-empty access for either [search] or [replication]");
        }
        if (this.search.isEmpty()) {
            clusterPrivileges = CCR_CLUSTER_PRIVILEGE_NAMES;
        } else if (this.replication.isEmpty()) {
            clusterPrivileges = CCS_CLUSTER_PRIVILEGE_NAMES;
        } else {
            clusterPrivileges = CCS_AND_CCR_CLUSTER_PRIVILEGE_NAMES;
            if (this.search.stream().anyMatch(RoleDescriptor.IndicesPrivileges::isUsingDocumentOrFieldLevelSecurity)) {
                throw new IllegalArgumentException("search does not support document or field level security if replication is assigned");
            }
        }
        if (this.replication.stream().anyMatch(RoleDescriptor.IndicesPrivileges::isUsingDocumentOrFieldLevelSecurity)) {
            throw new IllegalArgumentException("replication does not support document or field level security");
        }
        return new RoleDescriptor(ROLE_DESCRIPTOR_NAME, clusterPrivileges, (RoleDescriptor.IndicesPrivileges[])CollectionUtils.concatLists(this.search, this.replication).toArray(RoleDescriptor.IndicesPrivileges[]::new), null);
    }

    public static CrossClusterApiKeyRoleDescriptorBuilder parse(String access) throws IOException {
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, access);){
            CrossClusterApiKeyRoleDescriptorBuilder crossClusterApiKeyRoleDescriptorBuilder = (CrossClusterApiKeyRoleDescriptorBuilder)PARSER.parse(parser, null);
            return crossClusterApiKeyRoleDescriptorBuilder;
        }
    }

    static void validate(RoleDescriptor roleDescriptor) {
        if (!ROLE_DESCRIPTOR_NAME.equals(roleDescriptor.getName())) {
            throw new IllegalArgumentException("invalid role descriptor name [" + roleDescriptor.getName() + "]");
        }
        if (roleDescriptor.hasApplicationPrivileges()) {
            throw new IllegalArgumentException("application privilege must be empty");
        }
        if (roleDescriptor.hasRunAs()) {
            throw new IllegalArgumentException("run_as privilege must be empty");
        }
        if (roleDescriptor.hasConfigurableClusterPrivileges()) {
            throw new IllegalArgumentException("configurable cluster privilege must be empty");
        }
        if (roleDescriptor.hasRemoteIndicesPrivileges()) {
            throw new IllegalArgumentException("remote indices privileges must be empty");
        }
        if (roleDescriptor.hasRemoteClusterPermissions()) {
            throw new IllegalArgumentException("remote cluster permissions must be empty");
        }
        Object[] clusterPrivileges = roleDescriptor.getClusterPrivileges();
        if (!(Arrays.asList(clusterPrivileges).contains("cross_cluster_search") || Arrays.asList(clusterPrivileges).contains("cross_cluster_replication"))) {
            throw new IllegalArgumentException("invalid cluster privileges: [" + Strings.arrayToCommaDelimitedString((Object[])clusterPrivileges) + "]");
        }
        RoleDescriptor.IndicesPrivileges[] indicesPrivileges = roleDescriptor.getIndicesPrivileges();
        if (indicesPrivileges.length == 0) {
            throw new IllegalArgumentException("indices privileges must not be empty");
        }
        for (RoleDescriptor.IndicesPrivileges indexPrivilege : indicesPrivileges) {
            Object[] privileges = indexPrivilege.getPrivileges();
            if (Arrays.equals(privileges, CCR_INDICES_PRIVILEGE_NAMES)) {
                if (!indexPrivilege.isUsingDocumentOrFieldLevelSecurity()) continue;
                throw new IllegalArgumentException("replication does not support document or field level security");
            }
            if (Arrays.equals(privileges, CCS_INDICES_PRIVILEGE_NAMES)) continue;
            throw new IllegalArgumentException("invalid indices privileges: [" + Strings.arrayToCommaDelimitedString((Object[])privileges));
        }
    }

    public static void checkForInvalidLegacyRoleDescriptors(String apiKeyId, List<RoleDescriptor> roleDescriptors) {
        RoleDescriptor.IndicesPrivileges[] indicesPrivileges;
        Object[] legacyClusterPrivileges;
        assert (roleDescriptors.size() == 1);
        RoleDescriptor roleDescriptor = roleDescriptors.get(0);
        Object[] clusterPrivileges = roleDescriptor.getClusterPrivileges();
        boolean hasBoth = Arrays.equals(clusterPrivileges, legacyClusterPrivileges = new String[]{"cross_cluster_search", "cross_cluster_replication"});
        if (!hasBoth) {
            return;
        }
        for (RoleDescriptor.IndicesPrivileges indexPrivilege : indicesPrivileges = roleDescriptor.getIndicesPrivileges()) {
            Object[] legacyIndicesPrivileges;
            Object[] privileges = indexPrivilege.getPrivileges();
            if (!Arrays.equals(privileges, legacyIndicesPrivileges = new String[]{"read", "read_cross_cluster", "view_index_metadata"}) || !indexPrivilege.isUsingDocumentOrFieldLevelSecurity()) continue;
            throw new IllegalArgumentException("Cross cluster API key [" + apiKeyId + "] is invalid: search does not support document or field level security if replication is assigned");
        }
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> RoleDescriptor.parseIndexWithPredefinedPrivileges(ROLE_DESCRIPTOR_NAME, CCS_INDICES_PRIVILEGE_NAMES, p), new ParseField("search", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> RoleDescriptor.parseIndexWithPredefinedPrivileges(ROLE_DESCRIPTOR_NAME, CCR_INDICES_PRIVILEGE_NAMES, p), new ParseField("replication", new String[0]));
    }
}

