/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ClusterAdminClient;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public final class MlIndexAndAlias {
    public static final String BWC_MAPPINGS_VERSION = "8.11.0";
    private static final Logger logger = LogManager.getLogger(MlIndexAndAlias.class);
    static final Comparator<String> INDEX_NAME_COMPARATOR = new Comparator<String>(){
        private final Predicate<String> HAS_SIX_DIGIT_SUFFIX = Pattern.compile("\\d{6}").asMatchPredicate();

        @Override
        public int compare(String index1, String index2) {
            String[] index1Parts = index1.split("-");
            String index1Suffix = index1Parts[index1Parts.length - 1];
            boolean index1HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.test(index1Suffix);
            String[] index2Parts = index2.split("-");
            String index2Suffix = index2Parts[index2Parts.length - 1];
            boolean index2HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.test(index2Suffix);
            if (index1HasSixDigitsSuffix && index2HasSixDigitsSuffix) {
                return index1Suffix.compareTo(index2Suffix);
            }
            if (index1HasSixDigitsSuffix != index2HasSixDigitsSuffix) {
                return Boolean.compare(index1HasSixDigitsSuffix, index2HasSixDigitsSuffix);
            }
            return index1.compareTo(index2);
        }
    };

    private MlIndexAndAlias() {
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String alias, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        Optional indexPointedByCurrentWriteAlias;
        ActionListener loggingListener = ActionListener.wrap(arg_0 -> finalListener.onResponse(arg_0), e -> {
            logger.error(() -> Strings.format((String)"Failed to create alias and index with pattern [%s] and alias [%s]", (Object[])new Object[]{indexPatternPrefix, alias}), (Throwable)e);
            finalListener.onFailure(e);
        });
        ActionListener indexCreatedListener = loggingListener.delegateFailureAndWrap((delegate, created) -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, alias, masterNodeTimeout, (ActionListener<Boolean>)delegate);
            } else {
                delegate.onResponse((Object)false);
            }
        });
        String legacyIndexWithoutSuffix = indexPatternPrefix;
        String indexPattern = indexPatternPrefix + "*";
        String firstConcreteIndex = indexPatternPrefix + "-000001";
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandHidden(), new String[]{indexPattern});
        Optional<Object> optional = indexPointedByCurrentWriteAlias = clusterState.getMetadata().hasAlias(alias) ? ((IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(alias)).getIndices().stream().map(Index::getName).findFirst() : Optional.empty();
        if (concreteIndexNames.length == 0) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, (ActionListener<Boolean>)indexCreatedListener);
                return;
            }
            logger.error("There are no indices matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (concreteIndexNames.length == 1 && concreteIndexNames[0].equals(legacyIndexWithoutSuffix)) {
            if (indexPointedByCurrentWriteAlias.isEmpty()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, (ActionListener<Boolean>)indexCreatedListener);
                return;
            }
            if (((String)indexPointedByCurrentWriteAlias.get()).equals(legacyIndexWithoutSuffix)) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, false, (ActionListener<Boolean>)indexCreatedListener.delegateFailureAndWrap((l, unused) -> MlIndexAndAlias.updateWriteAlias(client, alias, legacyIndexWithoutSuffix, firstConcreteIndex, (ActionListener<Boolean>)l)));
                return;
            }
            logger.error("There is exactly one index (i.e. '{}') matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)legacyIndexWithoutSuffix, (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (indexPointedByCurrentWriteAlias.isEmpty()) {
            assert (concreteIndexNames.length > 0);
            String latestConcreteIndexName = Arrays.stream(concreteIndexNames).max(INDEX_NAME_COMPARATOR).get();
            MlIndexAndAlias.updateWriteAlias(client, alias, null, latestConcreteIndexName, (ActionListener<Boolean>)loggingListener);
            return;
        }
        loggingListener.onResponse((Object)false);
    }

    public static void createSystemIndexIfNecessary(Client client, ClusterState clusterState, SystemIndexDescriptor descriptor, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        String primaryIndex = descriptor.getPrimaryIndex();
        if (clusterState.getMetadata().hasIndexAbstraction(primaryIndex)) {
            finalListener.onResponse((Object)true);
            return;
        }
        ActionListener indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, primaryIndex, masterNodeTimeout, finalListener);
            } else {
                finalListener.onResponse((Object)false);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                finalListener.onResponse((Object)true);
            } else {
                finalListener.onFailure(e);
            }
        });
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(primaryIndex);
        createIndexRequest.settings(descriptor.getSettings());
        createIndexRequest.mapping(descriptor.getMappings());
        createIndexRequest.origin("ml");
        createIndexRequest.masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, indexCreatedListener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)r.isAcknowledged())), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
    }

    private static void waitForShardsReady(Client client, String index, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        ClusterHealthRequest healthRequest = new ClusterHealthRequest(masterNodeTimeout, new String[]{index}).waitForYellowStatus().waitForNoRelocatingShards(true).waitForNoInitializingShards(true);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", healthRequest, listener.delegateFailureAndWrap((l, response) -> l.onResponse((Object)(!response.isTimedOut() ? 1 : 0))), (arg_0, arg_1) -> ((ClusterAdminClient)client.admin().cluster()).health(arg_0, arg_1));
    }

    private static void createFirstConcreteIndex(Client client, String index, String alias, boolean addAlias, ActionListener<Boolean> listener) {
        logger.info("About to create first concrete index [{}] with alias [{}]", (Object)index, (Object)alias);
        CreateIndexRequestBuilder requestBuilder = client.admin().indices().prepareCreate(index);
        if (addAlias) {
            requestBuilder.addAlias(new Alias(alias).isHidden(Boolean.valueOf(true)));
        }
        CreateIndexRequest request = (CreateIndexRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(createIndexResponse -> listener.onResponse((Object)true), createIndexFailure -> {
            if (ExceptionsHelper.unwrapCause(createIndexFailure) instanceof ResourceAlreadyExistsException) {
                if (addAlias) {
                    MlIndexAndAlias.updateWriteAlias(client, alias, null, index, listener);
                } else {
                    listener.onResponse((Object)true);
                }
            } else {
                listener.onFailure(createIndexFailure);
            }
        }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
    }

    private static void updateWriteAlias(Client client, String alias, @Nullable String currentIndex, String newIndex, ActionListener<Boolean> listener) {
        logger.info("About to move write alias [{}] from index [{}] to index [{}]", (Object)alias, (Object)currentIndex, (Object)newIndex);
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases().addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias).isHidden(Boolean.valueOf(true)));
        if (currentIndex != null) {
            requestBuilder.removeAlias(currentIndex, alias);
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, listener.delegateFailureAndWrap((l, resp) -> l.onResponse((Object)resp.isAcknowledged())), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, IndexTemplateConfig templateConfig, TimeValue masterTimeout, ActionListener<Boolean> listener) {
        TransportPutComposableIndexTemplateAction.Request request;
        String templateName = templateConfig.getTemplateName();
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateName)) {
            listener.onResponse((Object)true);
            return;
        }
        try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, templateConfig.loadBytes());){
            request = (TransportPutComposableIndexTemplateAction.Request)new TransportPutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse((XContentParser)parser)).masterNodeTimeout(masterTimeout);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
        }
        MlIndexAndAlias.installIndexTemplateIfRequired(clusterState, client, request, listener);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, TransportPutComposableIndexTemplateAction.Request templateRequest, ActionListener<Boolean> listener) {
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, templateRequest.name())) {
            listener.onResponse((Object)true);
            return;
        }
        ActionListener innerListener = listener.delegateFailureAndWrap((l, response) -> {
            if (!response.isAcknowledged()) {
                logger.warn("error adding template [{}], request was not acknowledged", (Object)templateRequest.name());
            }
            l.onResponse((Object)response.isAcknowledged());
        });
        ClientHelper.executeAsyncWithOrigin(client, "ml", TransportPutComposableIndexTemplateAction.TYPE, templateRequest, innerListener);
    }

    public static boolean hasIndexTemplate(ClusterState state, String templateName) {
        return state.getMetadata().templatesV2().containsKey(templateName);
    }
}

