/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.search;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.search.WeightedTokensQueryBuilder;

public class TokenPruningConfig
implements Writeable,
ToXContentObject {
    public static final ParseField TOKENS_FREQ_RATIO_THRESHOLD = new ParseField("tokens_freq_ratio_threshold", new String[0]);
    public static final ParseField TOKENS_WEIGHT_THRESHOLD = new ParseField("tokens_weight_threshold", new String[0]);
    public static final ParseField ONLY_SCORE_PRUNED_TOKENS_FIELD = new ParseField("only_score_pruned_tokens", new String[0]);
    public static final float DEFAULT_TOKENS_FREQ_RATIO_THRESHOLD = 5.0f;
    public static final float MAX_TOKENS_FREQ_RATIO_THRESHOLD = 100.0f;
    public static final float DEFAULT_TOKENS_WEIGHT_THRESHOLD = 0.4f;
    private final float tokensFreqRatioThreshold;
    private final float tokensWeightThreshold;
    private final boolean onlyScorePrunedTokens;

    public TokenPruningConfig() {
        this(5.0f, 0.4f, false);
    }

    public TokenPruningConfig(float tokensFreqRatioThreshold, float tokensWeightThreshold, boolean onlyScorePrunedTokens) {
        if (tokensFreqRatioThreshold < 1.0f || tokensFreqRatioThreshold > 100.0f) {
            throw new IllegalArgumentException("[" + TOKENS_FREQ_RATIO_THRESHOLD.getPreferredName() + "] must be between [1] and [" + String.format(Locale.ROOT, "%d", 100) + "], got " + tokensFreqRatioThreshold);
        }
        if (tokensWeightThreshold < 0.0f || tokensWeightThreshold > 1.0f) {
            throw new IllegalArgumentException("[" + TOKENS_WEIGHT_THRESHOLD.getPreferredName() + "] must be between 0 and 1");
        }
        this.tokensFreqRatioThreshold = tokensFreqRatioThreshold;
        this.tokensWeightThreshold = tokensWeightThreshold;
        this.onlyScorePrunedTokens = onlyScorePrunedTokens;
    }

    public TokenPruningConfig(StreamInput in) throws IOException {
        this.tokensFreqRatioThreshold = in.readFloat();
        this.tokensWeightThreshold = in.readFloat();
        this.onlyScorePrunedTokens = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.tokensFreqRatioThreshold);
        out.writeFloat(this.tokensWeightThreshold);
        out.writeBoolean(this.onlyScorePrunedTokens);
    }

    public float getTokensFreqRatioThreshold() {
        return this.tokensFreqRatioThreshold;
    }

    public float getTokensWeightThreshold() {
        return this.tokensWeightThreshold;
    }

    public boolean isOnlyScorePrunedTokens() {
        return this.onlyScorePrunedTokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenPruningConfig that = (TokenPruningConfig)o;
        return Float.compare(that.tokensFreqRatioThreshold, this.tokensFreqRatioThreshold) == 0 && Float.compare(that.tokensWeightThreshold, this.tokensWeightThreshold) == 0 && this.onlyScorePrunedTokens == that.onlyScorePrunedTokens;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.tokensFreqRatioThreshold), Float.valueOf(this.tokensWeightThreshold), this.onlyScorePrunedTokens);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TOKENS_FREQ_RATIO_THRESHOLD.getPreferredName(), this.tokensFreqRatioThreshold);
        builder.field(TOKENS_WEIGHT_THRESHOLD.getPreferredName(), this.tokensWeightThreshold);
        if (this.onlyScorePrunedTokens) {
            builder.field(ONLY_SCORE_PRUNED_TOKENS_FIELD.getPreferredName(), this.onlyScorePrunedTokens);
        }
        builder.endObject();
        return builder;
    }

    public static TokenPruningConfig fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        float ratioThreshold = 5.0f;
        float weightThreshold = 0.4f;
        boolean onlyScorePrunedTokens = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_OBJECT) continue;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                if (Set.of(TOKENS_FREQ_RATIO_THRESHOLD.getPreferredName(), TOKENS_WEIGHT_THRESHOLD.getPreferredName(), ONLY_SCORE_PRUNED_TOKENS_FIELD.getPreferredName()).contains(currentFieldName)) continue;
                throw new ParsingException(parser.getTokenLocation(), "[" + WeightedTokensQueryBuilder.PRUNING_CONFIG.getPreferredName() + "] unknown token [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (TOKENS_FREQ_RATIO_THRESHOLD.match(currentFieldName, parser.getDeprecationHandler())) {
                    ratioThreshold = parser.intValue();
                    continue;
                }
                if (TOKENS_WEIGHT_THRESHOLD.match(currentFieldName, parser.getDeprecationHandler())) {
                    weightThreshold = parser.floatValue();
                    continue;
                }
                if (ONLY_SCORE_PRUNED_TOKENS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    onlyScorePrunedTokens = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[" + WeightedTokensQueryBuilder.PRUNING_CONFIG.getPreferredName() + "] does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[" + WeightedTokensQueryBuilder.PRUNING_CONFIG.getPreferredName() + "] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        return new TokenPruningConfig(ratioThreshold, weightThreshold, onlyScorePrunedTokens);
    }
}

