/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.ChunkedInferenceServiceResults;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.MlChunkedTextExpansionResults;
import org.elasticsearch.xpack.core.ml.search.WeightedToken;

public class InferenceChunkedSparseEmbeddingResults
implements ChunkedInferenceServiceResults {
    public static final String NAME = "chunked_sparse_embedding_results";
    public static final String FIELD_NAME = "sparse_embedding_chunk";
    private final List<MlChunkedTextExpansionResults.ChunkedResult> chunkedResults;

    public static InferenceChunkedSparseEmbeddingResults ofMlResult(MlChunkedTextExpansionResults mlInferenceResults) {
        return new InferenceChunkedSparseEmbeddingResults(mlInferenceResults.getChunks());
    }

    public static List<ChunkedInferenceServiceResults> listOf(List<String> inputs, SparseEmbeddingResults sparseEmbeddingResults) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, sparseEmbeddingResults.embeddings().size());
        ArrayList<ChunkedInferenceServiceResults> results = new ArrayList<ChunkedInferenceServiceResults>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(InferenceChunkedSparseEmbeddingResults.ofSingle(inputs.get(i), sparseEmbeddingResults.embeddings().get(i)));
        }
        return results;
    }

    private static InferenceChunkedSparseEmbeddingResults ofSingle(String input, SparseEmbeddingResults.Embedding embedding) {
        List<WeightedToken> weightedTokens = embedding.tokens().stream().map(weightedToken -> new WeightedToken(weightedToken.token(), weightedToken.weight())).toList();
        return new InferenceChunkedSparseEmbeddingResults(List.of(new MlChunkedTextExpansionResults.ChunkedResult(input, weightedTokens)));
    }

    public InferenceChunkedSparseEmbeddingResults(List<MlChunkedTextExpansionResults.ChunkedResult> chunks) {
        this.chunkedResults = chunks;
    }

    public InferenceChunkedSparseEmbeddingResults(StreamInput in) throws IOException {
        this.chunkedResults = in.readCollectionAsList(MlChunkedTextExpansionResults.ChunkedResult::new);
    }

    public List<MlChunkedTextExpansionResults.ChunkedResult> getChunkedResults() {
        return this.chunkedResults;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array((String)FIELD_NAME, this.chunkedResults.iterator());
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.chunkedResults);
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the coordindated action");
    }

    public List<? extends InferenceResults> transformToLegacyFormat() {
        throw new UnsupportedOperationException("Chunked results are not returned in the legacy format");
    }

    public Map<String, Object> asMap() {
        return Map.of(FIELD_NAME, this.chunkedResults.stream().map(MlChunkedTextExpansionResults.ChunkedResult::asMap).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceChunkedSparseEmbeddingResults that = (InferenceChunkedSparseEmbeddingResults)o;
        return Objects.equals(this.chunkedResults, that.chunkedResults);
    }

    public int hashCode() {
        return Objects.hash(this.chunkedResults);
    }

    public Iterator<ChunkedInferenceServiceResults.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) {
        return this.chunkedResults.stream().map(chunk -> new ChunkedInferenceServiceResults.Chunk(chunk.matchedText(), InferenceChunkedSparseEmbeddingResults.toBytesReference(xcontent, chunk.weightedTokens()))).iterator();
    }

    private static BytesReference toBytesReference(XContent xContent, List<WeightedToken> tokens) {
        try {
            XContentBuilder b = XContentBuilder.builder((XContent)xContent);
            b.startObject();
            for (WeightedToken weightedToken : tokens) {
                weightedToken.toXContent(b, ToXContent.EMPTY_PARAMS);
            }
            b.endObject();
            return BytesReference.bytes((XContentBuilder)b);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }
}

