/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ccr;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ccr.action.ImmutableFollowParameters;

public class AutoFollowMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "ccr_auto_follow";
    private static final ParseField PATTERNS_FIELD = new ParseField("patterns", new String[0]);
    private static final ParseField FOLLOWED_LEADER_INDICES_FIELD = new ParseField("followed_leader_indices", new String[0]);
    private static final ParseField HEADERS = new ParseField("headers", new String[0]);
    private static final ConstructingObjectParser<AutoFollowMetadata, Void> PARSER = new ConstructingObjectParser("auto_follow", args -> new AutoFollowMetadata((Map)args[0], (Map)args[1], (Map)args[2]));
    public static final AutoFollowMetadata EMPTY;
    private final Map<String, AutoFollowPattern> patterns;
    private final Map<String, List<String>> followedLeaderIndexUUIDs;
    private final Map<String, Map<String, String>> headers;

    public static AutoFollowMetadata fromXContent(XContentParser parser) throws IOException {
        return (AutoFollowMetadata)((Object)PARSER.parse(parser, null));
    }

    public AutoFollowMetadata(Map<String, AutoFollowPattern> patterns, Map<String, List<String>> followedLeaderIndexUUIDs, Map<String, Map<String, String>> headers) {
        this.patterns = Collections.unmodifiableMap(patterns);
        this.followedLeaderIndexUUIDs = Collections.unmodifiableMap(followedLeaderIndexUUIDs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableList((List)e.getValue()))));
        this.headers = Collections.unmodifiableMap(headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.unmodifiableMap((Map)e.getValue()))));
    }

    public AutoFollowMetadata(StreamInput in) throws IOException {
        this(in.readMap(AutoFollowPattern::readFrom), in.readMapOfLists(StreamInput::readString), in.readMap(valIn -> valIn.readMap(StreamInput::readString)));
    }

    public Map<String, AutoFollowPattern> getPatterns() {
        return this.patterns;
    }

    public Map<String, List<String>> getFollowedLeaderIndexUUIDs() {
        return this.followedLeaderIndexUUIDs;
    }

    public Map<String, Map<String, String>> getHeaders() {
        return this.headers;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.SNAPSHOT, Metadata.XContentContext.GATEWAY);
    }

    public String getWriteableName() {
        return TYPE;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.patterns, StreamOutput::writeWriteable);
        out.writeMap(this.followedLeaderIndexUUIDs, StreamOutput::writeStringCollection);
        out.writeMap(this.headers, (valOut, header) -> valOut.writeMap(header, StreamOutput::writeString));
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContent.builder((ToXContent.Params)params).xContentObjectFieldObjects(PATTERNS_FIELD.getPreferredName(), this.patterns).object(FOLLOWED_LEADER_INDICES_FIELD.getPreferredName(), this.followedLeaderIndexUUIDs).object(HEADERS.getPreferredName(), this.headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoFollowMetadata that = (AutoFollowMetadata)((Object)o);
        return Objects.equals(this.patterns, that.patterns) && Objects.equals(this.followedLeaderIndexUUIDs, that.followedLeaderIndexUUIDs) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.patterns, this.followedLeaderIndexUUIDs, this.headers);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> {
            HashMap<String, AutoFollowPattern> patterns = new HashMap<String, AutoFollowPattern>();
            String fieldName = null;
            XContentParser.Token token = p.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = p.currentName();
                } else if (token == XContentParser.Token.START_OBJECT) {
                    patterns.put(fieldName, (AutoFollowPattern)AutoFollowPattern.PARSER.parse(p, c));
                } else {
                    throw new ElasticsearchParseException("unexpected token [" + token + "]", new Object[0]);
                }
                token = p.nextToken();
            }
            return patterns;
        }, PATTERNS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), FOLLOWED_LEADER_INDICES_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), HEADERS);
        EMPTY = new AutoFollowMetadata(Map.of(), Map.of(), Map.of());
    }

    public static class AutoFollowPattern
    extends ImmutableFollowParameters
    implements ToXContentFragment {
        public static final ParseField ACTIVE = new ParseField("active", new String[0]);
        public static final ParseField REMOTE_CLUSTER_FIELD = new ParseField("remote_cluster", new String[0]);
        public static final ParseField LEADER_PATTERNS_FIELD = new ParseField("leader_index_patterns", new String[0]);
        public static final ParseField LEADER_EXCLUSION_PATTERNS_FIELD = new ParseField("leader_index_exclusion_patterns", new String[0]);
        public static final ParseField FOLLOW_PATTERN_FIELD = new ParseField("follow_index_pattern", new String[0]);
        public static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
        private static final ConstructingObjectParser<AutoFollowPattern, Void> PARSER = new ConstructingObjectParser("auto_follow_pattern", args -> new AutoFollowPattern((String)args[0], (List)args[1], args[2] == null ? Collections.emptyList() : (List)args[2], (String)args[3], args[4] == null ? Settings.EMPTY : (Settings)args[4], args[5] == null || (Boolean)args[5] != false, (Integer)args[6], (Integer)args[7], (Integer)args[8], (Integer)args[9], (ByteSizeValue)args[10], (ByteSizeValue)args[11], (Integer)args[12], (ByteSizeValue)args[13], (TimeValue)args[14], (TimeValue)args[15]));
        private final String remoteCluster;
        private final List<String> leaderIndexPatterns;
        private final List<String> leaderIndexExclusionPatterns;
        private final String followIndexPattern;
        private final Settings settings;
        private final boolean active;

        public AutoFollowPattern(String remoteCluster, List<String> leaderIndexPatterns, List<String> leaderIndexExclusionPatterns, String followIndexPattern, Settings settings, boolean active, Integer maxReadRequestOperationCount, Integer maxWriteRequestOperationCount, Integer maxOutstandingReadRequests, Integer maxOutstandingWriteRequests, ByteSizeValue maxReadRequestSize, ByteSizeValue maxWriteRequestSize, Integer maxWriteBufferCount, ByteSizeValue maxWriteBufferSize, TimeValue maxRetryDelay, TimeValue pollTimeout) {
            super(maxReadRequestOperationCount, maxWriteRequestOperationCount, maxOutstandingReadRequests, maxOutstandingWriteRequests, maxReadRequestSize, maxWriteRequestSize, maxWriteBufferCount, maxWriteBufferSize, maxRetryDelay, pollTimeout);
            this.remoteCluster = remoteCluster;
            this.leaderIndexPatterns = leaderIndexPatterns;
            this.leaderIndexExclusionPatterns = Objects.requireNonNull(leaderIndexExclusionPatterns);
            this.followIndexPattern = followIndexPattern;
            this.settings = Objects.requireNonNull(settings);
            this.active = active;
        }

        public static AutoFollowPattern readFrom(StreamInput in) throws IOException {
            String remoteCluster = in.readString();
            List leaderIndexPatterns = in.readStringCollectionAsList();
            String followIndexPattern = in.readOptionalString();
            Settings settings = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_9_0) ? Settings.readSettingsFromStream((StreamInput)in) : Settings.EMPTY;
            return new AutoFollowPattern(remoteCluster, leaderIndexPatterns, followIndexPattern, settings, in);
        }

        private AutoFollowPattern(String remoteCluster, List<String> leaderIndexPatterns, String followIndexPattern, Settings settings, StreamInput in) throws IOException {
            super(in);
            this.remoteCluster = remoteCluster;
            this.leaderIndexPatterns = leaderIndexPatterns;
            this.followIndexPattern = followIndexPattern;
            this.settings = Objects.requireNonNull(settings);
            this.active = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_5_0) ? in.readBoolean() : true;
            this.leaderIndexExclusionPatterns = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_14_0) ? in.readStringCollectionAsList() : Collections.emptyList();
        }

        public boolean match(IndexAbstraction indexAbstraction) {
            return AutoFollowPattern.match(this.leaderIndexPatterns, this.leaderIndexExclusionPatterns, indexAbstraction);
        }

        public static boolean match(List<String> leaderIndexPatterns, List<String> leaderIndexExclusionPatterns, IndexAbstraction indexAbstraction) {
            boolean matches;
            boolean bl = matches = !indexAbstraction.isSystem() && !Regex.simpleMatch(leaderIndexExclusionPatterns, (String)indexAbstraction.getName()) && Regex.simpleMatch(leaderIndexPatterns, (String)indexAbstraction.getName());
            if (matches) {
                return true;
            }
            DataStream parentDataStream = indexAbstraction.getParentDataStream();
            return parentDataStream != null && !parentDataStream.isSystem() && !Regex.simpleMatch(leaderIndexExclusionPatterns, (String)indexAbstraction.getParentDataStream().getName()) && Regex.simpleMatch(leaderIndexPatterns, (String)indexAbstraction.getParentDataStream().getName());
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public List<String> getLeaderIndexExclusionPatterns() {
            return this.leaderIndexExclusionPatterns;
        }

        public String getFollowIndexPattern() {
            return this.followIndexPattern;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.remoteCluster);
            out.writeStringCollection(this.leaderIndexPatterns);
            out.writeOptionalString(this.followIndexPattern);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_9_0)) {
                this.settings.writeTo(out);
            }
            super.writeTo(out);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_5_0)) {
                out.writeBoolean(this.active);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_7_14_0)) {
                out.writeStringCollection(this.leaderIndexExclusionPatterns);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(ACTIVE.getPreferredName(), this.active);
            builder.field(REMOTE_CLUSTER_FIELD.getPreferredName(), this.remoteCluster);
            builder.array(LEADER_PATTERNS_FIELD.getPreferredName(), this.leaderIndexPatterns.toArray(new String[0]));
            builder.array(LEADER_EXCLUSION_PATTERNS_FIELD.getPreferredName(), this.leaderIndexExclusionPatterns.toArray(new String[0]));
            if (this.followIndexPattern != null) {
                builder.field(FOLLOW_PATTERN_FIELD.getPreferredName(), this.followIndexPattern);
            }
            if (!this.settings.isEmpty()) {
                builder.startObject(SETTINGS_FIELD.getPreferredName());
                this.settings.toXContent(builder, params);
                builder.endObject();
            }
            this.toXContentFragment(builder);
            return builder;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AutoFollowPattern pattern = (AutoFollowPattern)o;
            return this.active == pattern.active && this.remoteCluster.equals(pattern.remoteCluster) && this.leaderIndexPatterns.equals(pattern.leaderIndexPatterns) && this.leaderIndexExclusionPatterns.equals(pattern.leaderIndexExclusionPatterns) && this.followIndexPattern.equals(pattern.followIndexPattern) && this.settings.equals((Object)pattern.settings);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.remoteCluster, this.leaderIndexPatterns, this.leaderIndexExclusionPatterns, this.followIndexPattern, this.settings, this.active);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), LEADER_PATTERNS_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), LEADER_EXCLUSION_PATTERNS_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FOLLOW_PATTERN_FIELD);
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent((XContentParser)p), SETTINGS_FIELD);
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ACTIVE);
            ImmutableFollowParameters.initParser(PARSER);
        }
    }
}

