/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.application;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;

public class EnterpriseSearchFeatureSetUsage
extends XPackFeatureSet.Usage {
    static final TransportVersion BEHAVIORAL_ANALYTICS_TRANSPORT_VERSION = TransportVersions.V_8_8_1;
    static final TransportVersion QUERY_RULES_TRANSPORT_VERSION = TransportVersions.V_8_10_X;
    public static final String SEARCH_APPLICATIONS = "search_applications";
    public static final String ANALYTICS_COLLECTIONS = "analytics_collections";
    public static final String QUERY_RULESETS = "query_rulesets";
    public static final String COUNT = "count";
    public static final String TOTAL_COUNT = "total_count";
    public static final String TOTAL_RULE_COUNT = "total_rule_count";
    public static final String MIN_RULE_COUNT = "min_rule_count";
    public static final String MAX_RULE_COUNT = "max_rule_count";
    public static final String RULE_CRITERIA_TOTAL_COUNTS = "rule_criteria_total_counts";
    public static final String RULE_TYPE_TOTAL_COUNTS = "rule_type_total_counts";
    private final Map<String, Object> searchApplicationsUsage;
    private final Map<String, Object> analyticsCollectionsUsage;
    private final Map<String, Object> queryRulesUsage;

    public EnterpriseSearchFeatureSetUsage(boolean available, boolean enabled, Map<String, Object> searchApplicationsUsage, Map<String, Object> analyticsCollectionsUsage, Map<String, Object> queryRulesUsage) {
        super("enterprise_search", available, enabled);
        this.searchApplicationsUsage = Objects.requireNonNull(searchApplicationsUsage);
        this.analyticsCollectionsUsage = Objects.requireNonNull(analyticsCollectionsUsage);
        this.queryRulesUsage = Objects.requireNonNull(queryRulesUsage);
    }

    public EnterpriseSearchFeatureSetUsage(StreamInput in) throws IOException {
        super(in);
        this.searchApplicationsUsage = in.readGenericMap();
        Map analyticsCollectionsUsage = new HashMap();
        Map queryRulesUsage = new HashMap();
        if (in.getTransportVersion().onOrAfter((VersionId)QUERY_RULES_TRANSPORT_VERSION)) {
            analyticsCollectionsUsage = in.readGenericMap();
            queryRulesUsage = in.readGenericMap();
        } else if (in.getTransportVersion().onOrAfter((VersionId)BEHAVIORAL_ANALYTICS_TRANSPORT_VERSION)) {
            analyticsCollectionsUsage = in.readGenericMap();
        }
        this.analyticsCollectionsUsage = analyticsCollectionsUsage;
        this.queryRulesUsage = queryRulesUsage;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeGenericMap(this.searchApplicationsUsage);
        if (out.getTransportVersion().onOrAfter((VersionId)BEHAVIORAL_ANALYTICS_TRANSPORT_VERSION)) {
            out.writeGenericMap(this.analyticsCollectionsUsage);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)QUERY_RULES_TRANSPORT_VERSION)) {
            out.writeGenericMap(this.queryRulesUsage);
        }
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_8_0;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.innerXContent(builder, params);
        builder.field(SEARCH_APPLICATIONS, this.searchApplicationsUsage);
        builder.field(ANALYTICS_COLLECTIONS, this.analyticsCollectionsUsage);
        builder.field(QUERY_RULESETS, this.queryRulesUsage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseSearchFeatureSetUsage that = (EnterpriseSearchFeatureSetUsage)o;
        return Objects.equals(this.searchApplicationsUsage, that.searchApplicationsUsage) && Objects.equals(this.analyticsCollectionsUsage, that.analyticsCollectionsUsage) && Objects.equals(this.queryRulesUsage, that.queryRulesUsage);
    }

    public int hashCode() {
        return Objects.hash(this.searchApplicationsUsage, this.analyticsCollectionsUsage, this.queryRulesUsage);
    }

    public Map<String, Object> getSearchApplicationsUsage() {
        return this.searchApplicationsUsage;
    }

    public Map<String, Object> getAnalyticsCollectionsUsage() {
        return this.analyticsCollectionsUsage;
    }

    public Map<String, Object> getQueryRulesUsage() {
        return this.queryRulesUsage;
    }
}

