/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final NodeClient client;
    private final List<ActionType<XPackUsageFeatureResponse>> usageActions;

    @Inject
    public TransportXPackUsageAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NodeClient client) {
        super("cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, XPackUsageRequest::new, indexNameExpressionResolver, XPackUsageResponse::new, (Executor)threadPool.executor("management"));
        this.client = client;
        this.usageActions = this.usageActions();
    }

    protected List<ActionType<XPackUsageFeatureResponse>> usageActions() {
        return XPackUsageFeatureAction.ALL;
    }

    protected void masterOperation(Task task, final XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) {
        new ActionRunnable<XPackUsageResponse>(listener){
            final List<XPackFeatureSet.Usage> responses;
            {
                super(arg0);
                this.responses = new ArrayList<XPackFeatureSet.Usage>(TransportXPackUsageAction.this.usageActions.size());
            }

            protected void doRun() {
                if (this.responses.size() < TransportXPackUsageAction.this.usageActions().size()) {
                    XPackUsageRequest childRequest = new XPackUsageRequest(request.masterNodeTimeout());
                    childRequest.setParentTask(request.getParentTask());
                    TransportXPackUsageAction.this.client.executeLocally(TransportXPackUsageAction.this.usageActions.get(this.responses.size()), (ActionRequest)childRequest, this.listener.delegateFailure((delegate, response) -> {
                        this.responses.add(response.getUsage());
                        this.run();
                    }));
                } else {
                    assert (this.responses.size() == TransportXPackUsageAction.this.usageActions.size()) : this.responses.size() + " vs " + TransportXPackUsageAction.this.usageActions.size();
                    this.listener.onResponse((Object)new XPackUsageResponse(this.responses));
                }
            }
        }.run();
    }

    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

