/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.shutdown.DeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.GetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.NodeSeenService;
import org.elasticsearch.xpack.shutdown.PutShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.RestDeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.RestGetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.RestPutShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.TransportDeleteShutdownNodeAction;
import org.elasticsearch.xpack.shutdown.TransportGetShutdownStatusAction;
import org.elasticsearch.xpack.shutdown.TransportPutShutdownNodeAction;

public class ShutdownPlugin
extends Plugin
implements ActionPlugin {
    public Collection<?> createComponents(Plugin.PluginServices services) {
        NodeSeenService nodeSeenService = new NodeSeenService(services.clusterService());
        return Collections.singletonList(nodeSeenService);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ActionPlugin.ActionHandler putShutdown = new ActionPlugin.ActionHandler((ActionType)PutShutdownNodeAction.INSTANCE, TransportPutShutdownNodeAction.class);
        ActionPlugin.ActionHandler deleteShutdown = new ActionPlugin.ActionHandler((ActionType)DeleteShutdownNodeAction.INSTANCE, TransportDeleteShutdownNodeAction.class);
        ActionPlugin.ActionHandler getStatus = new ActionPlugin.ActionHandler((ActionType)GetShutdownStatusAction.INSTANCE, TransportGetShutdownStatusAction.class);
        return Arrays.asList(putShutdown, deleteShutdown, getStatus);
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Arrays.asList(new RestHandler[]{new RestPutShutdownNodeAction(), new RestDeleteShutdownNodeAction(), new RestGetShutdownStatusAction()});
    }

    static boolean serializesWithParentTaskAndTimeouts(TransportVersion transportVersion) {
        return transportVersion.isPatchFrom(TransportVersions.V_8_13_4) || transportVersion.isPatchFrom(TransportVersions.V_8_14_0) || transportVersion.onOrAfter((VersionId)TransportVersions.SHUTDOWN_REQUEST_TIMEOUTS_FIX);
    }
}

