/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle;

import java.io.Closeable;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ResultDeduplicator;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockRequest;
import org.elasticsearch.action.admin.indices.readonly.AddIndexBlockResponse;
import org.elasticsearch.action.admin.indices.readonly.TransportAddIndexBlockAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.settings.put.TransportUpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.datastreams.lifecycle.ErrorEntry;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.scheduler.SchedulerEngine;
import org.elasticsearch.common.scheduler.TimeValueSchedule;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.datastreams.lifecycle.DataStreamLifecycleErrorStore;
import org.elasticsearch.datastreams.lifecycle.downsampling.DeleteSourceAndAddDownsampleIndexExecutor;
import org.elasticsearch.datastreams.lifecycle.downsampling.DeleteSourceAndAddDownsampleToDS;
import org.elasticsearch.datastreams.lifecycle.health.DataStreamLifecycleHealthInfoPublisher;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class DataStreamLifecycleService
implements ClusterStateListener,
Closeable,
SchedulerEngine.Listener {
    public static final String DATA_STREAM_LIFECYCLE_POLL_INTERVAL = "data_streams.lifecycle.poll_interval";
    public static final Setting<TimeValue> DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING = Setting.timeSetting((String)"data_streams.lifecycle.poll_interval", (TimeValue)TimeValue.timeValueMinutes((long)5L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final ByteSizeValue ONE_HUNDRED_MB = ByteSizeValue.ofMb((long)100L);
    public static final int TARGET_MERGE_FACTOR_VALUE = 16;
    public static final Setting<Integer> DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING = Setting.intSetting((String)"data_streams.lifecycle.target.merge.policy.merge_factor", (int)16, (int)2, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING = Setting.byteSizeSetting((String)"data_streams.lifecycle.target.merge.policy.floor_segment", (ByteSizeValue)ONE_HUNDRED_MB, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> DATA_STREAM_SIGNALLING_ERROR_RETRY_INTERVAL_SETTING = Setting.intSetting((String)"data_streams.lifecycle.signalling.error_retry_interval", (int)10, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final String DOWNSAMPLED_INDEX_PREFIX = "downsample-";
    private static final Logger logger = LogManager.getLogger(DataStreamLifecycleService.class);
    private static final String LIFECYCLE_JOB_NAME = "data_stream_lifecycle";
    public static final String FORCE_MERGE_COMPLETED_TIMESTAMP_METADATA_KEY = "force_merge_completed_timestamp";
    private final Settings settings;
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    final ResultDeduplicator<TransportRequest, Void> transportActionsDeduplicator;
    final ResultDeduplicator<String, Void> clusterStateChangesDeduplicator;
    private final DataStreamLifecycleHealthInfoPublisher dslHealthInfoPublisher;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;
    private LongSupplier nowSupplier;
    private final Clock clock;
    private final DataStreamLifecycleErrorStore errorStore;
    private volatile boolean isMaster = false;
    private volatile TimeValue pollInterval;
    private volatile RolloverConfiguration rolloverConfiguration;
    private SchedulerEngine.Job scheduledJob;
    private final SetOnce<SchedulerEngine> scheduler = new SetOnce();
    private final MasterServiceTaskQueue<UpdateForceMergeCompleteTask> forceMergeClusterStateUpdateTaskQueue;
    private final MasterServiceTaskQueue<DeleteSourceAndAddDownsampleToDS> swapSourceWithDownsampleIndexQueue;
    private volatile ByteSizeValue targetMergePolicyFloorSegment;
    private volatile int targetMergePolicyFactor;
    private volatile int signallingErrorRetryInterval;
    private volatile Long lastRunStartedAt = null;
    private volatile Long lastRunDuration = null;
    private volatile Long timeBetweenStarts = null;
    private static final SimpleBatchedExecutor<UpdateForceMergeCompleteTask, Void> FORCE_MERGE_STATE_UPDATE_TASK_EXECUTOR = new SimpleBatchedExecutor<UpdateForceMergeCompleteTask, Void>(){

        public Tuple<ClusterState, Void> executeTask(UpdateForceMergeCompleteTask task, ClusterState clusterState) throws Exception {
            return Tuple.tuple((Object)task.execute(clusterState), null);
        }

        public void taskSucceeded(UpdateForceMergeCompleteTask task, Void unused) {
            logger.trace("Updated cluster state for force merge of index [{}]", (Object)task.targetIndex);
            task.listener.onResponse(null);
        }
    };

    public DataStreamLifecycleService(Settings settings, Client client, ClusterService clusterService, Clock clock, ThreadPool threadPool, LongSupplier nowSupplier, DataStreamLifecycleErrorStore errorStore, AllocationService allocationService, DataStreamLifecycleHealthInfoPublisher dataStreamLifecycleHealthInfoPublisher, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.clock = clock;
        this.threadPool = threadPool;
        this.transportActionsDeduplicator = new ResultDeduplicator(threadPool.getThreadContext());
        this.clusterStateChangesDeduplicator = new ResultDeduplicator(threadPool.getThreadContext());
        this.nowSupplier = nowSupplier;
        this.errorStore = errorStore;
        this.globalRetentionSettings = globalRetentionSettings;
        this.scheduledJob = null;
        this.pollInterval = (TimeValue)DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING.get(settings);
        this.targetMergePolicyFloorSegment = (ByteSizeValue)DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING.get(settings);
        this.targetMergePolicyFactor = (Integer)DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING.get(settings);
        this.signallingErrorRetryInterval = (Integer)DATA_STREAM_SIGNALLING_ERROR_RETRY_INTERVAL_SETTING.get(settings);
        this.rolloverConfiguration = (RolloverConfiguration)clusterService.getClusterSettings().get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING);
        this.forceMergeClusterStateUpdateTaskQueue = clusterService.createTaskQueue("data-stream-lifecycle-forcemerge-state-update", Priority.LOW, FORCE_MERGE_STATE_UPDATE_TASK_EXECUTOR);
        this.swapSourceWithDownsampleIndexQueue = clusterService.createTaskQueue("data-stream-lifecycle-swap-source-with-downsample", Priority.URGENT, (ClusterStateTaskExecutor)new DeleteSourceAndAddDownsampleIndexExecutor(allocationService));
        this.dslHealthInfoPublisher = dataStreamLifecycleHealthInfoPublisher;
    }

    public void init() {
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_LIFECYCLE_POLL_INTERVAL_SETTING, this::updatePollInterval);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING, this::updateRolloverConfiguration);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_MERGE_POLICY_TARGET_FACTOR_SETTING, this::updateMergePolicyFactor);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_MERGE_POLICY_TARGET_FLOOR_SEGMENT_SETTING, this::updateMergePolicyFloorSegment);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(DATA_STREAM_SIGNALLING_ERROR_RETRY_INTERVAL_SETTING, this::updateSignallingRetryThreshold);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        boolean prevIsMaster = this.isMaster;
        if (prevIsMaster != event.localNodeMaster()) {
            this.isMaster = event.localNodeMaster();
            if (this.isMaster) {
                this.maybeScheduleJob();
            } else {
                this.cancelJob();
                this.transportActionsDeduplicator.clear();
                logger.trace("Clearing the error store as we are not the elected master anymore");
                this.errorStore.clearStore();
            }
        }
    }

    @Override
    public void close() {
        SchedulerEngine engine = (SchedulerEngine)this.scheduler.get();
        if (engine != null) {
            engine.stop();
        }
        logger.trace("Clearing the error store as we are closing");
        this.errorStore.clearStore();
    }

    public void triggered(SchedulerEngine.Event event) {
        if (event.jobName().equals(LIFECYCLE_JOB_NAME) && this.isMaster) {
            logger.trace("Data stream lifecycle job triggered: {}, {}, {}", (Object)event.jobName(), (Object)event.scheduledTime(), (Object)event.triggeredTime());
            this.run(this.clusterService.state());
            this.dslHealthInfoPublisher.publishDslErrorEntries(new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    assert (acknowledgedResponse.isAcknowledged()) : "updating the health info is always acknowledged";
                }

                public void onFailure(Exception e) {
                    logger.debug(String.format(Locale.ROOT, "unable to update the health cache with DSL errors related information due to [%s]. Will retry on the next DSL run", e.getMessage()), (Throwable)e);
                }
            });
        }
    }

    void run(ClusterState state) {
        long startTime = this.nowSupplier.getAsLong();
        if (this.lastRunStartedAt != null) {
            this.timeBetweenStarts = startTime - this.lastRunStartedAt;
        }
        this.lastRunStartedAt = startTime;
        int affectedIndices = 0;
        int affectedDataStreams = 0;
        for (DataStream dataStream : state.metadata().dataStreams().values()) {
            this.clearErrorStoreForUnmanagedIndices(dataStream);
            if (dataStream.getLifecycle() == null) continue;
            HashSet<Index> indicesToExcludeForRemainingRun = new HashSet<Index>();
            indicesToExcludeForRemainingRun.addAll(this.maybeExecuteRollover(state, dataStream));
            indicesToExcludeForRemainingRun.addAll(DataStreamLifecycleService.timeSeriesIndicesStillWithinTimeBounds(state.metadata(), DataStreamLifecycleService.getTargetIndices(dataStream, indicesToExcludeForRemainingRun, arg_0 -> ((Metadata)state.metadata()).index(arg_0), false), this.nowSupplier));
            try {
                indicesToExcludeForRemainingRun.addAll(this.maybeExecuteRetention(state, dataStream, indicesToExcludeForRemainingRun));
            }
            catch (Exception e) {
                logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle failed to execute retention for data stream [%s]", dataStream.getName()), (Throwable)e);
            }
            try {
                indicesToExcludeForRemainingRun.addAll(this.maybeExecuteForceMerge(state, DataStreamLifecycleService.getTargetIndices(dataStream, indicesToExcludeForRemainingRun, arg_0 -> ((Metadata)state.metadata()).index(arg_0), true)));
            }
            catch (Exception e) {
                logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle failed to execute force merge for data stream [%s]", dataStream.getName()), (Throwable)e);
            }
            try {
                indicesToExcludeForRemainingRun.addAll(this.maybeExecuteDownsampling(state, dataStream, DataStreamLifecycleService.getTargetIndices(dataStream, indicesToExcludeForRemainingRun, arg_0 -> ((Metadata)state.metadata()).index(arg_0), false)));
            }
            catch (Exception e) {
                logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle failed to execute downsampling for data stream [%s]", dataStream.getName()), (Throwable)e);
            }
            affectedIndices += indicesToExcludeForRemainingRun.size();
            ++affectedDataStreams;
        }
        this.lastRunDuration = this.nowSupplier.getAsLong() - this.lastRunStartedAt;
        logger.trace("Data stream lifecycle service run for {} and performed operations on [{}] indices, part of [{}] data streams", (Object)TimeValue.timeValueMillis((long)this.lastRunDuration).toHumanReadableString(2), (Object)affectedIndices, (Object)affectedDataStreams);
    }

    static Set<Index> timeSeriesIndicesStillWithinTimeBounds(Metadata metadata, List<Index> targetIndices, LongSupplier nowSupplier) {
        HashSet<Index> tsIndicesWithinBounds = new HashSet<Index>();
        for (Index index : targetIndices) {
            IndexMetadata backingIndex = metadata.index(index);
            assert (backingIndex != null) : "the data stream backing indices must exist";
            if (IndexSettings.MODE.get(backingIndex.getSettings()) != IndexMode.TIME_SERIES) continue;
            Instant configuredEndTime = (Instant)IndexSettings.TIME_SERIES_END_TIME.get(backingIndex.getSettings());
            assert (configuredEndTime != null) : "a time series index must have an end time configured but [" + index.getName() + "] does not";
            if (nowSupplier.getAsLong() > configuredEndTime.toEpochMilli()) continue;
            logger.trace("Data stream lifecycle will not perform any operations in this run on time series index [{}] because its configured [{}] end time has not lapsed", (Object)index.getName(), (Object)configuredEndTime);
            tsIndicesWithinBounds.add(index);
        }
        return tsIndicesWithinBounds;
    }

    Set<Index> maybeExecuteDownsampling(ClusterState state, DataStream dataStream, List<Index> targetIndices) {
        HashSet<Index> affectedIndices = new HashSet<Index>();
        Metadata metadata = state.metadata();
        for (Index index : targetIndices) {
            IndexMetadata backingIndexMeta = metadata.index(index);
            assert (backingIndexMeta != null) : "the data stream backing indices must exist";
            List downsamplingRounds = dataStream.getDownsamplingRoundsFor(index, arg_0 -> ((Metadata)metadata).index(arg_0), this.nowSupplier);
            if (downsamplingRounds.isEmpty()) continue;
            String indexName = index.getName();
            String downsamplingSourceIndex = (String)IndexMetadata.INDEX_DOWNSAMPLE_SOURCE_NAME.get(backingIndexMeta.getSettings());
            if (!org.elasticsearch.common.Strings.hasText((String)downsamplingSourceIndex) && !state.blocks().indexBlocked(ClusterBlockLevel.WRITE, indexName)) {
                affectedIndices.add(index);
                this.addIndexBlockOnce(indexName);
                continue;
            }
            affectedIndices.addAll(this.waitForInProgressOrTriggerDownsampling(dataStream, backingIndexMeta, downsamplingRounds, metadata));
        }
        return affectedIndices;
    }

    private Set<Index> waitForInProgressOrTriggerDownsampling(DataStream dataStream, IndexMetadata backingIndex, List<DataStreamLifecycle.Downsampling.Round> downsamplingRounds, Metadata metadata) {
        assert (dataStream.getIndices().contains(backingIndex.getIndex())) : "the provided backing index must be part of data stream:" + dataStream.getName();
        assert (!downsamplingRounds.isEmpty()) : "the index should be managed and have matching downsampling rounds";
        HashSet<Index> affectedIndices = new HashSet<Index>();
        DataStreamLifecycle.Downsampling.Round lastRound = downsamplingRounds.get(downsamplingRounds.size() - 1);
        Index index = backingIndex.getIndex();
        String indexName = index.getName();
        for (DataStreamLifecycle.Downsampling.Round round : downsamplingRounds) {
            boolean targetDownsampleIndexExists;
            String downsampleIndexName = DownsampleConfig.generateDownsampleIndexName((String)DOWNSAMPLED_INDEX_PREFIX, (IndexMetadata)backingIndex, (DateHistogramInterval)round.config().getFixedInterval());
            IndexMetadata targetDownsampleIndexMeta = metadata.index(downsampleIndexName);
            boolean bl = targetDownsampleIndexExists = targetDownsampleIndexMeta != null;
            if (targetDownsampleIndexExists) {
                Set<Index> downsamplingNotComplete = this.evaluateDownsampleStatus(dataStream, (IndexMetadata.DownsampleTaskStatus)IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(targetDownsampleIndexMeta.getSettings()), round, lastRound, index, targetDownsampleIndexMeta.getIndex());
                if (downsamplingNotComplete.isEmpty()) continue;
                affectedIndices.addAll(downsamplingNotComplete);
                break;
            }
            if (!round.equals((Object)lastRound)) continue;
            affectedIndices.add(index);
            this.downsampleIndexOnce(round, indexName, downsampleIndexName);
        }
        return affectedIndices;
    }

    private void downsampleIndexOnce(DataStreamLifecycle.Downsampling.Round round, String sourceIndex, String downsampleIndexName) {
        DownsampleAction.Request request = new DownsampleAction.Request(TimeValue.THIRTY_SECONDS, sourceIndex, downsampleIndexName, null, round.config());
        this.transportActionsDeduplicator.executeOnce((Object)request, (ActionListener)new ErrorRecordingActionListener("indices:admin/xpack/downsample", sourceIndex, this.errorStore, Strings.format((String)"Data stream lifecycle encountered an error trying to downsample index [%s]. Data stream lifecycle will attempt to downsample the index on its next run.", (Object[])new Object[]{sourceIndex}), this.signallingErrorRetryInterval), (req, reqListener) -> this.downsampleIndex(request, (ActionListener<Void>)reqListener));
    }

    private Set<Index> evaluateDownsampleStatus(DataStream dataStream, IndexMetadata.DownsampleTaskStatus downsampleStatus, DataStreamLifecycle.Downsampling.Round currentRound, DataStreamLifecycle.Downsampling.Round lastRound, Index backingIndex, Index downsampleIndex) {
        HashSet<Index> affectedIndices = new HashSet<Index>();
        String indexName = backingIndex.getName();
        String downsampleIndexName = downsampleIndex.getName();
        return switch (downsampleStatus) {
            default -> throw new IncompatibleClassChangeError();
            case IndexMetadata.DownsampleTaskStatus.UNKNOWN -> {
                if (currentRound.equals((Object)lastRound)) {
                    DataStreamLifecycleService.recordAndLogError(indexName, this.errorStore, (Exception)new ResourceAlreadyExistsException(downsampleIndexName, new Object[0]), String.format(Locale.ROOT, "Data stream lifecycle service is unable to downsample backing index [%s] for data stream [%s] and donwsampling round [%s] because the target downsample index [%s] already exists", indexName, dataStream.getName(), currentRound, downsampleIndexName), this.signallingErrorRetryInterval);
                }
                yield affectedIndices;
            }
            case IndexMetadata.DownsampleTaskStatus.STARTED -> {
                logger.trace("Data stream lifecycle service waits for index [{}] to be downsampled. Current status is [{}] and the downsample index name is [{}]", (Object)indexName, (Object)IndexMetadata.DownsampleTaskStatus.STARTED, (Object)downsampleIndexName);
                this.downsampleIndexOnce(currentRound, indexName, downsampleIndexName);
                affectedIndices.add(backingIndex);
                yield affectedIndices;
            }
            case IndexMetadata.DownsampleTaskStatus.SUCCESS -> {
                if (!dataStream.getIndices().contains(downsampleIndex)) {
                    affectedIndices.add(backingIndex);
                    this.replaceBackingIndexWithDownsampleIndexOnce(dataStream, indexName, downsampleIndexName);
                }
                yield affectedIndices;
            }
        };
    }

    private void replaceBackingIndexWithDownsampleIndexOnce(DataStream dataStream, String backingIndexName, String downsampleIndexName) {
        String requestName = "dsl-replace-" + dataStream.getName() + "-" + backingIndexName + "-" + downsampleIndexName;
        this.clusterStateChangesDeduplicator.executeOnce((Object)requestName, (ActionListener)new ErrorRecordingActionListener(requestName, backingIndexName, this.errorStore, Strings.format((String)"Data stream lifecycle encountered an error trying to replace index [%s] with index [%s] in data stream [%s]", (Object[])new Object[]{backingIndexName, downsampleIndexName, dataStream}), this.signallingErrorRetryInterval), (req, reqListener) -> {
            logger.trace("Data stream lifecycle issues request to replace index [{}] with index [{}] in data stream [{}]", (Object)backingIndexName, (Object)downsampleIndexName, (Object)dataStream);
            this.swapSourceWithDownsampleIndexQueue.submitTask("data-stream-lifecycle-delete-source[" + backingIndexName + "]-add-to-datastream-[" + downsampleIndexName + "]", (ClusterStateTaskListener)new DeleteSourceAndAddDownsampleToDS(this.settings, dataStream.getName(), backingIndexName, downsampleIndexName, (ActionListener<Void>)reqListener), null);
        });
    }

    private void deleteIndexOnce(String indexName, String reason) {
        DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)new DeleteIndexRequest(indexName).masterNodeTimeout(TimeValue.MAX_VALUE);
        this.transportActionsDeduplicator.executeOnce((Object)deleteIndexRequest, (ActionListener)new ErrorRecordingActionListener(TransportDeleteIndexAction.TYPE.name(), indexName, this.errorStore, Strings.format((String)"Data stream lifecycle encountered an error trying to delete index [%s]", (Object[])new Object[]{indexName}), this.signallingErrorRetryInterval), (req, reqListener) -> this.deleteIndex(deleteIndexRequest, reason, (ActionListener<Void>)reqListener));
    }

    private void addIndexBlockOnce(String indexName) {
        AddIndexBlockRequest addIndexBlockRequest = (AddIndexBlockRequest)new AddIndexBlockRequest(IndexMetadata.APIBlock.WRITE, new String[]{indexName}).masterNodeTimeout(TimeValue.MAX_VALUE);
        this.transportActionsDeduplicator.executeOnce((Object)addIndexBlockRequest, (ActionListener)new ErrorRecordingActionListener(TransportAddIndexBlockAction.TYPE.name(), indexName, this.errorStore, Strings.format((String)"Data stream lifecycle service encountered an error trying to mark index [%s] as readonly", (Object[])new Object[]{indexName}), this.signallingErrorRetryInterval), (req, reqListener) -> this.addIndexBlock(addIndexBlockRequest, (ActionListener<Void>)reqListener));
    }

    static List<Index> getTargetIndices(DataStream dataStream, Set<Index> indicesToExcludeForRemainingRun, Function<String, IndexMetadata> indexMetadataSupplier, boolean withFailureStore) {
        ArrayList<Index> targetIndices = new ArrayList<Index>();
        for (Index index : dataStream.getIndices()) {
            if (!dataStream.isIndexManagedByDataStreamLifecycle(index, indexMetadataSupplier) || indicesToExcludeForRemainingRun.contains(index)) continue;
            targetIndices.add(index);
        }
        if (withFailureStore && DataStream.isFailureStoreFeatureFlagEnabled() && !dataStream.getFailureIndices().getIndices().isEmpty()) {
            for (Index index : dataStream.getFailureIndices().getIndices()) {
                if (!dataStream.isIndexManagedByDataStreamLifecycle(index, indexMetadataSupplier) || indicesToExcludeForRemainingRun.contains(index)) continue;
                targetIndices.add(index);
            }
        }
        return targetIndices;
    }

    private void clearErrorStoreForUnmanagedIndices(DataStream dataStream) {
        Metadata metadata = this.clusterService.state().metadata();
        for (String indexName : this.errorStore.getAllIndices()) {
            DataStream parentDataStream;
            IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(indexName);
            DataStream dataStream2 = parentDataStream = indexAbstraction != null ? indexAbstraction.getParentDataStream() : null;
            if (indexAbstraction == null || parentDataStream == null) {
                logger.trace("Clearing recorded error for index [{}] because the index doesn't exist or is not a data stream backing index anymore", (Object)indexName);
                this.errorStore.clearRecordedError(indexName);
                continue;
            }
            if (!parentDataStream.getName().equals(dataStream.getName())) continue;
            IndexMetadata indexMeta = metadata.index(indexName);
            if (dataStream.isIndexManagedByDataStreamLifecycle(indexMeta.getIndex(), arg_0 -> ((Metadata)metadata).index(arg_0))) continue;
            logger.trace("Clearing recorded error for index [{}] because the index is not managed by DSL anymore", (Object)indexName);
            this.errorStore.clearRecordedError(indexName);
        }
    }

    private Set<Index> maybeExecuteRollover(ClusterState state, DataStream dataStream) {
        Index failureStoreWriteIndex;
        HashSet<Index> currentRunWriteIndices = new HashSet<Index>();
        currentRunWriteIndices.add(this.maybeExecuteRollover(state, dataStream, false));
        if (DataStream.isFailureStoreFeatureFlagEnabled() && (failureStoreWriteIndex = this.maybeExecuteRollover(state, dataStream, true)) != null) {
            currentRunWriteIndices.add(failureStoreWriteIndex);
        }
        return currentRunWriteIndices;
    }

    @Nullable
    private Index maybeExecuteRollover(ClusterState state, DataStream dataStream, boolean rolloverFailureStore) {
        Index currentRunWriteIndex;
        block4: {
            Index index = currentRunWriteIndex = rolloverFailureStore ? dataStream.getFailureStoreWriteIndex() : dataStream.getWriteIndex();
            if (currentRunWriteIndex == null) {
                return null;
            }
            try {
                if (dataStream.isIndexManagedByDataStreamLifecycle(currentRunWriteIndex, arg_0 -> ((Metadata)state.metadata()).index(arg_0))) {
                    RolloverRequest rolloverRequest = DataStreamLifecycleService.getDefaultRolloverRequest(this.rolloverConfiguration, dataStream.getName(), dataStream.getLifecycle().getEffectiveDataRetention(this.globalRetentionSettings.get(), dataStream.isInternal()), rolloverFailureStore);
                    this.transportActionsDeduplicator.executeOnce((Object)rolloverRequest, (ActionListener)new ErrorRecordingActionListener("indices:admin/rollover", currentRunWriteIndex.getName(), this.errorStore, Strings.format((String)"Data stream lifecycle encountered an error trying to roll over%s data stream [%s]", (Object[])new Object[]{rolloverFailureStore ? " the failure store of " : "", dataStream.getName()}), this.signallingErrorRetryInterval), (req, reqListener) -> this.rolloverDataStream(currentRunWriteIndex.getName(), rolloverRequest, (ActionListener<Void>)reqListener));
                }
            }
            catch (Exception e) {
                logger.error(() -> String.format(Locale.ROOT, "Data stream lifecycle encountered an error trying to roll over%s data stream [%s]", rolloverFailureStore ? " the failure store of " : "", dataStream.getName()), (Throwable)e);
                DataStream latestDataStream = (DataStream)this.clusterService.state().metadata().dataStreams().get(dataStream.getName());
                if (latestDataStream == null || !latestDataStream.getWriteIndex().getName().equals(currentRunWriteIndex.getName())) break block4;
                this.errorStore.recordError(currentRunWriteIndex.getName(), e);
            }
        }
        return currentRunWriteIndex;
    }

    Set<Index> maybeExecuteRetention(ClusterState state, DataStream dataStream, Set<Index> indicesToExcludeForRemainingRun) {
        Metadata metadata = state.metadata();
        DataStreamGlobalRetention globalRetention = dataStream.isSystem() ? null : this.globalRetentionSettings.get();
        List backingIndicesOlderThanRetention = dataStream.getIndicesPastRetention(arg_0 -> ((Metadata)metadata).index(arg_0), this.nowSupplier, globalRetention);
        if (backingIndicesOlderThanRetention.isEmpty()) {
            return Set.of();
        }
        HashSet<Index> indicesToBeRemoved = new HashSet<Index>();
        assert (dataStream.getLifecycle() != null);
        TimeValue effectiveDataRetention = dataStream.getLifecycle().getEffectiveDataRetention(globalRetention, dataStream.isInternal());
        for (Index index : backingIndicesOlderThanRetention) {
            if (indicesToExcludeForRemainingRun.contains(index)) continue;
            IndexMetadata backingIndex = metadata.index(index);
            assert (backingIndex != null) : "the data stream backing indices must exist";
            IndexMetadata.DownsampleTaskStatus downsampleStatus = (IndexMetadata.DownsampleTaskStatus)IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(backingIndex.getSettings());
            if (downsampleStatus == IndexMetadata.DownsampleTaskStatus.STARTED) {
                logger.trace("Data stream lifecycle skips deleting index [{}] even though its retention period [{}] has lapsed because there's a downsampling operation currently in progress for this index. Current downsampling status is [{}]. When downsampling completes, DSL will delete this index.", (Object)index.getName(), (Object)effectiveDataRetention, (Object)downsampleStatus);
                continue;
            }
            indicesToBeRemoved.add(index);
            String indexName = backingIndex.getIndex().getName();
            this.deleteIndexOnce(indexName, "the lapsed [" + effectiveDataRetention + "] retention period");
        }
        return indicesToBeRemoved;
    }

    private Set<Index> maybeExecuteForceMerge(ClusterState state, List<Index> indices) {
        Metadata metadata = state.metadata();
        HashSet<Index> affectedIndices = new HashSet<Index>();
        for (Index index : indices) {
            IndexMetadata backingIndex = metadata.index(index);
            assert (backingIndex != null) : "the data stream backing indices must exist";
            String indexName = index.getName();
            boolean alreadyForceMerged = DataStreamLifecycleService.isForceMergeComplete(backingIndex);
            if (alreadyForceMerged) {
                logger.trace("Already force merged {}", (Object)indexName);
                continue;
            }
            ByteSizeValue configuredFloorSegmentMerge = (ByteSizeValue)MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING.get(backingIndex.getSettings());
            Integer configuredMergeFactor = (Integer)MergePolicyConfig.INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING.get(backingIndex.getSettings());
            if (configuredFloorSegmentMerge == null || !configuredFloorSegmentMerge.equals((Object)this.targetMergePolicyFloorSegment) || configuredMergeFactor == null || !configuredMergeFactor.equals(this.targetMergePolicyFactor)) {
                UpdateSettingsRequest updateMergePolicySettingsRequest = new UpdateSettingsRequest();
                updateMergePolicySettingsRequest.indicesOptions(IndicesOptions.builder((IndicesOptions)updateMergePolicySettingsRequest.indicesOptions()).selectorOptions(IndicesOptions.SelectorOptions.DATA_AND_FAILURE).build());
                updateMergePolicySettingsRequest.indices(new String[]{indexName});
                updateMergePolicySettingsRequest.settings(Settings.builder().put(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING.getKey(), this.targetMergePolicyFloorSegment).put(MergePolicyConfig.INDEX_MERGE_POLICY_MERGE_FACTOR_SETTING.getKey(), this.targetMergePolicyFactor));
                updateMergePolicySettingsRequest.masterNodeTimeout(TimeValue.MAX_VALUE);
                affectedIndices.add(index);
                this.transportActionsDeduplicator.executeOnce((Object)updateMergePolicySettingsRequest, (ActionListener)new ErrorRecordingActionListener(TransportUpdateSettingsAction.TYPE.name(), indexName, this.errorStore, Strings.format((String)"Data stream lifecycle encountered an error trying to to update settings [%s] for index [%s]", (Object[])new Object[]{updateMergePolicySettingsRequest.settings().keySet(), indexName}), this.signallingErrorRetryInterval), (req, reqListener) -> this.updateIndexSetting(updateMergePolicySettingsRequest, (ActionListener<Void>)reqListener));
                continue;
            }
            affectedIndices.add(index);
            ForceMergeRequest forceMergeRequest = new ForceMergeRequest(new String[]{indexName});
            this.transportActionsDeduplicator.executeOnce((Object)new ForceMergeRequestWrapper(forceMergeRequest), (ActionListener)new ErrorRecordingActionListener("indices:admin/forcemerge", indexName, this.errorStore, Strings.format((String)"Data stream lifecycle encountered an error trying to force merge index [%s]. Data stream lifecycle will attempt to force merge the index on its next run.", (Object[])new Object[]{indexName}), this.signallingErrorRetryInterval), (req, reqListener) -> this.forceMergeIndex(forceMergeRequest, (ActionListener<Void>)reqListener));
        }
        return affectedIndices;
    }

    private void rolloverDataStream(final String writeIndexName, RolloverRequest rolloverRequest, final ActionListener<Void> listener) {
        final String rolloverTarget = rolloverRequest.getRolloverTarget();
        logger.trace("Data stream lifecycle issues rollover request for data stream [{}]", (Object)rolloverTarget);
        this.client.admin().indices().rolloverIndex(rolloverRequest, (ActionListener)new ActionListener<RolloverResponse>(){

            public void onResponse(RolloverResponse rolloverResponse) {
                if (rolloverResponse.isRolledOver()) {
                    List<String> metConditions = rolloverResponse.getConditionStatus().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).toList();
                    logger.info("Data stream lifecycle successfully rolled over datastream [{}] due to the following met rollover conditions {}. The new index is [{}]", (Object)rolloverTarget, metConditions, (Object)rolloverResponse.getNewIndex());
                }
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                DataStream dataStream = (DataStream)DataStreamLifecycleService.this.clusterService.state().metadata().dataStreams().get(rolloverTarget);
                if (dataStream == null || !dataStream.getWriteIndex().getName().equals(writeIndexName)) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    private void updateIndexSetting(final UpdateSettingsRequest updateSettingsRequest, final ActionListener<Void> listener) {
        assert (updateSettingsRequest.indices() != null && updateSettingsRequest.indices().length == 1) : "Data stream lifecycle service updates the settings for one index at a time";
        final String targetIndex = updateSettingsRequest.indices()[0];
        logger.trace("Data stream lifecycle service issues request to update settings [{}] for index [{}]", (Object)updateSettingsRequest.settings().keySet(), (Object)targetIndex);
        this.client.admin().indices().updateSettings(updateSettingsRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                logger.info("Data stream lifecycle service successfully updated settings [{}] for index index [{}]", (Object)updateSettingsRequest.settings().keySet(), (Object)targetIndex);
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    logger.trace("Clearing recorded error for index [{}] because the index was deleted", (Object)targetIndex);
                    DataStreamLifecycleService.this.errorStore.clearRecordedError(targetIndex);
                    listener.onResponse(null);
                    return;
                }
                listener.onFailure(e);
            }
        });
    }

    private void addIndexBlock(final AddIndexBlockRequest addIndexBlockRequest, final ActionListener<Void> listener) {
        assert (addIndexBlockRequest.indices() != null && addIndexBlockRequest.indices().length == 1) : "Data stream lifecycle service updates the index block for one index at a time";
        final String targetIndex = addIndexBlockRequest.indices()[0];
        logger.trace("Data stream lifecycle service issues request to add block [{}] for index [{}]", (Object)addIndexBlockRequest.getBlock(), (Object)targetIndex);
        this.client.admin().indices().addBlock(addIndexBlockRequest, (ActionListener)new ActionListener<AddIndexBlockResponse>(){

            public void onResponse(AddIndexBlockResponse addIndexBlockResponse) {
                if (addIndexBlockResponse.isAcknowledged()) {
                    logger.info("Data stream lifecycle service successfully added block [{}] for index index [{}]", (Object)addIndexBlockRequest.getBlock(), (Object)targetIndex);
                    listener.onResponse(null);
                } else {
                    Optional<AddIndexBlockResponse.AddBlockResult> resultForTargetIndex = addIndexBlockResponse.getIndices().stream().filter(blockResult -> blockResult.getIndex().getName().equals(targetIndex)).findAny();
                    if (resultForTargetIndex.isEmpty()) {
                        logger.trace("Data stream lifecycle service received an unacknowledged response when attempting to add the read-only block to index [{}], but the response didn't contain an explicit result for the index.", (Object)targetIndex);
                        listener.onFailure((Exception)new ElasticsearchException("request to mark index [" + targetIndex + "] as read-only was not acknowledged", new Object[0]));
                    } else if (resultForTargetIndex.get().hasFailures()) {
                        AddIndexBlockResponse.AddBlockResult blockResult2 = resultForTargetIndex.get();
                        if (blockResult2.getException() != null) {
                            listener.onFailure(blockResult2.getException());
                        } else {
                            ArrayList<AddIndexBlockResponse.AddBlockShardResult.Failure> shardFailures = new ArrayList<AddIndexBlockResponse.AddBlockShardResult.Failure>(blockResult2.getShards().length);
                            for (AddIndexBlockResponse.AddBlockShardResult shard : blockResult2.getShards()) {
                                if (!shard.hasFailures()) continue;
                                shardFailures.addAll(Arrays.asList(shard.getFailures()));
                            }
                            assert (!shardFailures.isEmpty()) : "The block response must have shard failures as the global exception is null. The block result is: " + blockResult2;
                            String errorMessage = org.elasticsearch.common.Strings.collectionToDelimitedString((Iterable)shardFailures.stream().map(org.elasticsearch.common.Strings::toString).collect(Collectors.toList()), (String)",");
                            listener.onFailure((Exception)new ElasticsearchException(errorMessage, new Object[0]));
                        }
                    } else {
                        listener.onFailure((Exception)new ElasticsearchException("request to mark index [" + targetIndex + "] as read-only was not acknowledged", new Object[0]));
                    }
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    logger.trace("Clearing recorded error for index [{}] because the index was deleted", (Object)targetIndex);
                    DataStreamLifecycleService.this.errorStore.clearRecordedError(targetIndex);
                    listener.onResponse(null);
                    return;
                }
                listener.onFailure(e);
            }
        });
    }

    private void deleteIndex(DeleteIndexRequest deleteIndexRequest, final String reason, final ActionListener<Void> listener) {
        assert (deleteIndexRequest.indices() != null && deleteIndexRequest.indices().length == 1) : "Data stream lifecycle deletes one index at a time";
        final String targetIndex = deleteIndexRequest.indices()[0];
        logger.trace("Data stream lifecycle issues request to delete index [{}]", (Object)targetIndex);
        this.client.admin().indices().delete(deleteIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                if (acknowledgedResponse.isAcknowledged()) {
                    logger.info("Data stream lifecycle successfully deleted index [{}] due to {}", (Object)targetIndex, (Object)reason);
                } else {
                    logger.trace("The delete request for index [{}] was not acknowledged. Data stream lifecycle service will retry on the next run if the index still exists", (Object)targetIndex);
                }
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    logger.trace("Data stream lifecycle did not delete index [{}] as it was already deleted", (Object)targetIndex);
                    DataStreamLifecycleService.this.errorStore.clearRecordedError(targetIndex);
                    listener.onResponse(null);
                    return;
                }
                if (e instanceof SnapshotInProgressException) {
                    logger.info("Data stream lifecycle was unable to delete index [{}] because it's currently being snapshot. Retrying on the next data stream lifecycle run", (Object)targetIndex);
                }
                listener.onFailure(e);
            }
        });
    }

    private void downsampleIndex(DownsampleAction.Request request, final ActionListener<Void> listener) {
        final String sourceIndex = request.getSourceIndex();
        final String downsampleIndex = request.getTargetIndex();
        logger.info("Data stream lifecycle issuing request to downsample index [{}] to index [{}]", (Object)sourceIndex, (Object)downsampleIndex);
        this.client.execute((ActionType)DownsampleAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                assert (acknowledgedResponse.isAcknowledged()) : "the downsample response is always acknowledged";
                logger.info("Data stream lifecycle successfully downsampled index [{}] to index [{}]", (Object)sourceIndex, (Object)downsampleIndex);
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void forceMergeIndex(ForceMergeRequest forceMergeRequest, final ActionListener<Void> listener) {
        assert (forceMergeRequest.indices() != null && forceMergeRequest.indices().length == 1) : "Data stream lifecycle force merges one index at a time";
        final String targetIndex = forceMergeRequest.indices()[0];
        logger.info("Data stream lifecycle is issuing a request to force merge index [{}]", (Object)targetIndex);
        this.client.admin().indices().forceMerge(forceMergeRequest, (ActionListener)new ActionListener<BroadcastResponse>(){

            public void onResponse(BroadcastResponse forceMergeResponse) {
                if (forceMergeResponse.getFailedShards() > 0) {
                    DefaultShardOperationFailedException[] failures = forceMergeResponse.getShardFailures();
                    String message = Strings.format((String)"Data stream lifecycle failed to forcemerge %d shards for index [%s] due to failures [%s]", (Object[])new Object[]{forceMergeResponse.getFailedShards(), targetIndex, failures == null ? "unknown" : Arrays.stream(failures).map(DefaultShardOperationFailedException::toString).collect(Collectors.joining(","))});
                    this.onFailure((Exception)new ElasticsearchException(message, new Object[0]));
                } else if (forceMergeResponse.getTotalShards() != forceMergeResponse.getSuccessfulShards()) {
                    String message = Strings.format((String)"Force merge request only had %d successful shards out of a total of %d", (Object[])new Object[]{forceMergeResponse.getSuccessfulShards(), forceMergeResponse.getTotalShards()});
                    this.onFailure((Exception)new ElasticsearchException(message, new Object[0]));
                } else {
                    logger.info("Data stream lifecycle successfully force merged index [{}]", (Object)targetIndex);
                    DataStreamLifecycleService.this.setForceMergeCompletedTimestamp(targetIndex, (ActionListener<Void>)listener);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void setForceMergeCompletedTimestamp(String targetIndex, ActionListener<Void> listener) {
        this.forceMergeClusterStateUpdateTaskQueue.submitTask(Strings.format((String)"Adding force merge complete marker to cluster state for [%s]", (Object[])new Object[]{targetIndex}), (ClusterStateTaskListener)new UpdateForceMergeCompleteTask(listener, targetIndex, this.threadPool), null);
    }

    private static boolean isForceMergeComplete(IndexMetadata backingIndex) {
        Map customMetadata = backingIndex.getCustomData(LIFECYCLE_JOB_NAME);
        return customMetadata != null && customMetadata.containsKey(FORCE_MERGE_COMPLETED_TIMESTAMP_METADATA_KEY);
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.lastRunDuration;
    }

    @Nullable
    public Long getTimeBetweenStarts() {
        return this.timeBetweenStarts;
    }

    static void recordAndLogError(String targetIndex, DataStreamLifecycleErrorStore errorStore, Exception e, String logMessage, int signallingErrorRetryThreshold) {
        ErrorEntry previousError = errorStore.recordError(targetIndex, e);
        ErrorEntry currentError = errorStore.getError(targetIndex);
        if (previousError == null || currentError != null && !previousError.error().equals(currentError.error())) {
            logger.error(logMessage, (Throwable)e);
        } else if (currentError != null) {
            if (currentError.retryCount() % signallingErrorRetryThreshold == 0) {
                logger.error(String.format(Locale.ROOT, "%s\nFailing since [%d], operation retried [%d] times", logMessage, currentError.firstOccurrenceTimestamp(), currentError.retryCount()), (Throwable)e);
            } else {
                logger.trace(String.format(Locale.ROOT, "%s\nFailing since [%d], operation retried [%d] times", logMessage, currentError.firstOccurrenceTimestamp(), currentError.retryCount()), (Throwable)e);
            }
        } else {
            logger.trace(String.format(Locale.ROOT, "Index [%s] encountered error [%s] but there's no record in the error store anymore", targetIndex, logMessage), (Throwable)e);
        }
    }

    static RolloverRequest getDefaultRolloverRequest(RolloverConfiguration rolloverConfiguration, String dataStream, TimeValue dataRetention, boolean rolloverFailureStore) {
        RolloverRequest rolloverRequest = (RolloverRequest)new RolloverRequest(dataStream, null).masterNodeTimeout(TimeValue.MAX_VALUE);
        if (rolloverFailureStore) {
            rolloverRequest.setIndicesOptions(IndicesOptions.builder((IndicesOptions)rolloverRequest.indicesOptions()).selectorOptions(IndicesOptions.SelectorOptions.ONLY_FAILURES).build());
        }
        rolloverRequest.setConditions(rolloverConfiguration.resolveRolloverConditions(dataRetention));
        return rolloverRequest;
    }

    private void updatePollInterval(TimeValue newInterval) {
        this.pollInterval = newInterval;
        this.maybeScheduleJob();
    }

    private void updateRolloverConfiguration(RolloverConfiguration newRolloverConfiguration) {
        this.rolloverConfiguration = newRolloverConfiguration;
    }

    private void updateMergePolicyFloorSegment(ByteSizeValue newFloorSegment) {
        this.targetMergePolicyFloorSegment = newFloorSegment;
    }

    private void updateMergePolicyFactor(int newFactor) {
        this.targetMergePolicyFactor = newFactor;
    }

    public void updateSignallingRetryThreshold(int retryThreshold) {
        this.signallingErrorRetryInterval = retryThreshold;
    }

    private void cancelJob() {
        if (this.scheduler.get() != null) {
            ((SchedulerEngine)this.scheduler.get()).remove(LIFECYCLE_JOB_NAME);
            this.scheduledJob = null;
        }
    }

    private boolean isClusterServiceStoppedOrClosed() {
        Lifecycle.State state = this.clusterService.lifecycleState();
        return state == Lifecycle.State.STOPPED || state == Lifecycle.State.CLOSED;
    }

    private void maybeScheduleJob() {
        if (!this.isMaster) {
            return;
        }
        if (this.isClusterServiceStoppedOrClosed()) {
            logger.trace("Skipping scheduling a data stream lifecycle job due to the cluster lifecycle state being: [{}] ", (Object)this.clusterService.lifecycleState());
            return;
        }
        if (this.scheduler.get() == null) {
            this.scheduler.set((Object)new SchedulerEngine(this.settings, this.clock));
            ((SchedulerEngine)this.scheduler.get()).register((SchedulerEngine.Listener)this);
        }
        assert (this.scheduler.get() != null) : "scheduler should be available";
        this.scheduledJob = new SchedulerEngine.Job(LIFECYCLE_JOB_NAME, (SchedulerEngine.Schedule)new TimeValueSchedule(this.pollInterval));
        ((SchedulerEngine)this.scheduler.get()).add(this.scheduledJob);
    }

    public DataStreamLifecycleErrorStore getErrorStore() {
        return this.errorStore;
    }

    public void setNowSupplier(LongSupplier nowSupplier) {
        this.nowSupplier = nowSupplier;
    }

    static class ErrorRecordingActionListener
    implements ActionListener<Void> {
        private final String actionName;
        private final String targetIndex;
        private final DataStreamLifecycleErrorStore errorStore;
        private final String errorLogMessage;
        private final int signallingErrorRetryThreshold;

        ErrorRecordingActionListener(String actionName, String targetIndex, DataStreamLifecycleErrorStore errorStore, String errorLogMessage, int signallingErrorRetryThreshold) {
            this.actionName = actionName;
            this.targetIndex = targetIndex;
            this.errorStore = errorStore;
            this.errorLogMessage = errorLogMessage;
            this.signallingErrorRetryThreshold = signallingErrorRetryThreshold;
        }

        public void onResponse(Void unused) {
            logger.trace("Clearing recorded error for index [{}] because the [{}] action was successful", (Object)this.targetIndex, (Object)this.actionName);
            this.errorStore.clearRecordedError(this.targetIndex);
        }

        public void onFailure(Exception e) {
            DataStreamLifecycleService.recordAndLogError(this.targetIndex, this.errorStore, e, this.errorLogMessage, this.signallingErrorRetryThreshold);
        }
    }

    static final class ForceMergeRequestWrapper
    extends ForceMergeRequest {
        ForceMergeRequestWrapper(ForceMergeRequest original) {
            super(original.indices());
            this.maxNumSegments(original.maxNumSegments());
            this.onlyExpungeDeletes(original.onlyExpungeDeletes());
            this.flush(original.flush());
            this.indicesOptions(original.indicesOptions());
            this.setShouldStoreResult(original.getShouldStoreResult());
            this.setRequestId(original.getRequestId());
            this.timeout(original.timeout());
            this.setParentTask(original.getParentTask());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            ForceMergeRequest that = (ForceMergeRequest)o;
            return Arrays.equals(this.indices, that.indices()) && this.maxNumSegments() == that.maxNumSegments() && this.onlyExpungeDeletes() == that.onlyExpungeDeletes() && this.flush() == that.flush() && Objects.equals(this.indicesOptions(), that.indicesOptions()) && this.getShouldStoreResult() == that.getShouldStoreResult() && this.getRequestId() == that.getRequestId() && Objects.equals(this.timeout(), that.timeout()) && Objects.equals(this.getParentTask(), that.getParentTask());
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices), this.maxNumSegments(), this.onlyExpungeDeletes(), this.flush(), this.indicesOptions(), this.getShouldStoreResult(), this.getRequestId(), this.timeout(), this.getParentTask());
        }
    }

    static class UpdateForceMergeCompleteTask
    implements ClusterStateTaskListener {
        private final ActionListener<Void> listener;
        private final String targetIndex;
        private final ThreadPool threadPool;

        UpdateForceMergeCompleteTask(ActionListener<Void> listener, String targetIndex, ThreadPool threadPool) {
            this.listener = listener;
            this.targetIndex = targetIndex;
            this.threadPool = threadPool;
        }

        ClusterState execute(ClusterState currentState) throws Exception {
            logger.debug("Updating cluster state with force merge complete marker for {}", (Object)this.targetIndex);
            IndexMetadata indexMetadata = currentState.metadata().index(this.targetIndex);
            Map customMetadata = indexMetadata.getCustomData(DataStreamLifecycleService.LIFECYCLE_JOB_NAME);
            HashMap<String, String> newCustomMetadata = new HashMap<String, String>();
            if (customMetadata != null) {
                newCustomMetadata.putAll(customMetadata);
            }
            newCustomMetadata.put(DataStreamLifecycleService.FORCE_MERGE_COMPLETED_TIMESTAMP_METADATA_KEY, Long.toString(this.threadPool.absoluteTimeInMillis()));
            IndexMetadata updatededIndexMetadata = new IndexMetadata.Builder(indexMetadata).putCustom(DataStreamLifecycleService.LIFECYCLE_JOB_NAME, newCustomMetadata).build();
            Metadata metadata = Metadata.builder((Metadata)currentState.metadata()).put(updatededIndexMetadata, true).build();
            return ClusterState.builder((ClusterState)currentState).metadata(metadata).build();
        }

        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

