/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.datastreams.DataStreamsStatsAction;
import org.elasticsearch.action.datastreams.GetDataStreamAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamsAction
extends TransportMasterNodeReadAction<GetDataStreamAction.Request, GetDataStreamAction.Response> {
    private static final Logger LOGGER = LogManager.getLogger(TransportGetDataStreamsAction.class);
    private final SystemIndices systemIndices;
    private final ClusterSettings clusterSettings;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;
    private final Client client;

    @Inject
    public TransportGetDataStreamsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, DataStreamGlobalRetentionSettings globalRetentionSettings, Client client) {
        super("indices:admin/data_stream/get", transportService, clusterService, threadPool, actionFilters, GetDataStreamAction.Request::new, indexNameExpressionResolver, GetDataStreamAction.Response::new, (Executor)transportService.getThreadPool().executor("management"));
        this.systemIndices = systemIndices;
        this.globalRetentionSettings = globalRetentionSettings;
        this.clusterSettings = clusterService.getClusterSettings();
        this.client = new OriginSettingClient(client, "stack");
    }

    protected void masterOperation(Task task, final GetDataStreamAction.Request request, final ClusterState state, final ActionListener<GetDataStreamAction.Response> listener) throws Exception {
        if (request.verbose()) {
            DataStreamsStatsAction.Request req = new DataStreamsStatsAction.Request();
            req.indices(request.indices());
            this.client.execute((ActionType)DataStreamsStatsAction.INSTANCE, (ActionRequest)req, (ActionListener)new ActionListener<DataStreamsStatsAction.Response>(){

                public void onResponse(DataStreamsStatsAction.Response response) {
                    Map<String, Long> maxTimestamps = Arrays.stream(response.getDataStreams()).collect(Collectors.toMap(DataStreamsStatsAction.DataStreamStats::getDataStream, DataStreamsStatsAction.DataStreamStats::getMaximumTimestamp));
                    listener.onResponse((Object)TransportGetDataStreamsAction.innerOperation(state, request, TransportGetDataStreamsAction.this.indexNameExpressionResolver, TransportGetDataStreamsAction.this.systemIndices, TransportGetDataStreamsAction.this.clusterSettings, TransportGetDataStreamsAction.this.globalRetentionSettings, maxTimestamps));
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            listener.onResponse((Object)TransportGetDataStreamsAction.innerOperation(state, request, this.indexNameExpressionResolver, this.systemIndices, this.clusterSettings, this.globalRetentionSettings, null));
        }
    }

    static GetDataStreamAction.Response innerOperation(ClusterState state, GetDataStreamAction.Request request, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, ClusterSettings clusterSettings, DataStreamGlobalRetentionSettings globalRetentionSettings, @Nullable Map<String, Long> maxTimestamps) {
        List<DataStream> dataStreams = TransportGetDataStreamsAction.getDataStreams(state, indexNameExpressionResolver, request);
        ArrayList<GetDataStreamAction.Response.DataStreamInfo> dataStreamInfos = new ArrayList<GetDataStreamAction.Response.DataStreamInfo>(dataStreams.size());
        for (DataStream dataStream : dataStreams) {
            String indexTemplate;
            boolean indexTemplatePreferIlmValue = true;
            String ilmPolicyName = null;
            if (dataStream.isSystem()) {
                SystemDataStreamDescriptor dataStreamDescriptor = systemIndices.findMatchingDataStreamDescriptor(dataStream.getName());
                String string = indexTemplate = dataStreamDescriptor != null ? dataStreamDescriptor.getDataStreamName() : null;
                if (dataStreamDescriptor != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings((ComposableIndexTemplate)dataStreamDescriptor.getComposableIndexTemplate(), (Map)dataStreamDescriptor.getComponentTemplates());
                    ilmPolicyName = settings.get("index.lifecycle.name");
                    indexTemplatePreferIlmValue = (Boolean)IndexSettings.PREFER_ILM_SETTING.get(settings);
                }
            } else {
                indexTemplate = MetadataIndexTemplateService.findV2Template((Metadata)state.metadata(), (String)dataStream.getName(), (boolean)false);
                if (indexTemplate != null) {
                    Settings settings = MetadataIndexTemplateService.resolveSettings((Metadata)state.metadata(), (String)indexTemplate);
                    ilmPolicyName = settings.get("index.lifecycle.name");
                    indexTemplatePreferIlmValue = (Boolean)IndexSettings.PREFER_ILM_SETTING.get(settings);
                } else {
                    LOGGER.warn("couldn't find any matching template for data stream [{}]. has it been restored (and possibly renamed)from a snapshot?", (Object)dataStream.getName());
                }
            }
            ClusterStateHealth streamHealth = new ClusterStateHealth(state, (String[])dataStream.getIndices().stream().map(Index::getName).toArray(String[]::new));
            HashMap<Index, GetDataStreamAction.Response.IndexProperties> backingIndicesSettingsValues = new HashMap<Index, GetDataStreamAction.Response.IndexProperties>();
            Metadata metadata = state.getMetadata();
            TransportGetDataStreamsAction.collectIndexSettingsValues(dataStream, backingIndicesSettingsValues, metadata, dataStream.getIndices());
            if (DataStream.isFailureStoreFeatureFlagEnabled() && !dataStream.getFailureIndices().getIndices().isEmpty()) {
                TransportGetDataStreamsAction.collectIndexSettingsValues(dataStream, backingIndicesSettingsValues, metadata, dataStream.getFailureIndices().getIndices());
            }
            GetDataStreamAction.Response.TimeSeries timeSeries = null;
            if (dataStream.getIndexMode() == IndexMode.TIME_SERIES) {
                ArrayList<Tuple> mergedRanges = new ArrayList<Tuple>();
                Tuple currentMergedRange = null;
                record IndexInfo(String name, Instant timeSeriesStart, Instant timeSeriesEnd) implements Comparable<IndexInfo>
                {
                    @Override
                    public int compareTo(IndexInfo o) {
                        return Comparator.comparing(IndexInfo::timeSeriesStart).thenComparing(IndexInfo::timeSeriesEnd).compare(this, o);
                    }
                }
                IndexInfo previous = null;
                List<IndexInfo> sortedRanges = dataStream.getIndices().stream().map(arg_0 -> ((Metadata)metadata).index(arg_0)).filter(m -> m.getIndexMode() == IndexMode.TIME_SERIES).map(m -> new IndexInfo(m.getIndex().getName(), m.getTimeSeriesStart(), m.getTimeSeriesEnd())).sorted().toList();
                for (IndexInfo info : sortedRanges) {
                    Instant start = info.timeSeriesStart();
                    Instant end = info.timeSeriesEnd();
                    if (currentMergedRange == null) {
                        currentMergedRange = new Tuple((Object)start, (Object)end);
                    } else if (((Instant)currentMergedRange.v2()).compareTo(start) == 0) {
                        currentMergedRange = new Tuple((Object)((Instant)currentMergedRange.v1()), (Object)end);
                    } else if (((Instant)currentMergedRange.v2()).compareTo(start) < 0) {
                        mergedRanges.add(currentMergedRange);
                        currentMergedRange = new Tuple((Object)start, (Object)end);
                    } else {
                        String message = "previous backing index [" + previous.name() + "] range [" + previous.timeSeriesStart() + "/" + previous.timeSeriesEnd() + "] range is colliding with current backing [" + info.name() + "] index range [" + start + "/" + end + "]";
                        assert (((Instant)currentMergedRange.v2()).compareTo(start) < 0) : message;
                    }
                    previous = info;
                }
                if (currentMergedRange != null) {
                    mergedRanges.add(currentMergedRange);
                }
                timeSeries = new GetDataStreamAction.Response.TimeSeries(mergedRanges);
            }
            dataStreamInfos.add(new GetDataStreamAction.Response.DataStreamInfo(dataStream, streamHealth.getStatus(), indexTemplate, ilmPolicyName, timeSeries, backingIndicesSettingsValues, indexTemplatePreferIlmValue, maxTimestamps == null ? null : maxTimestamps.get(dataStream.getName())));
        }
        return new GetDataStreamAction.Response(dataStreamInfos, request.includeDefaults() ? (RolloverConfiguration)clusterSettings.get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING) : null, globalRetentionSettings.get());
    }

    private static void collectIndexSettingsValues(DataStream dataStream, Map<Index, GetDataStreamAction.Response.IndexProperties> backingIndicesSettingsValues, Metadata metadata, List<Index> backingIndices) {
        for (Index index : backingIndices) {
            IndexMetadata indexMetadata = metadata.index(index);
            Boolean preferIlm = (Boolean)IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings());
            assert (preferIlm != null) : "must use the default prefer ilm setting value, if nothing else";
            GetDataStreamAction.Response.ManagedBy managedBy = metadata.isIndexManagedByILM(indexMetadata) ? GetDataStreamAction.Response.ManagedBy.ILM : (dataStream.isIndexManagedByDataStreamLifecycle(index, arg_0 -> ((Metadata)metadata).index(arg_0)) ? GetDataStreamAction.Response.ManagedBy.LIFECYCLE : GetDataStreamAction.Response.ManagedBy.UNMANAGED);
            backingIndicesSettingsValues.put(index, new GetDataStreamAction.Response.IndexProperties(preferIlm.booleanValue(), indexMetadata.getLifecyclePolicyName(), managedBy));
        }
    }

    static List<DataStream> getDataStreams(ClusterState clusterState, IndexNameExpressionResolver iner, GetDataStreamAction.Request request) {
        List results = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)iner, (ClusterState)clusterState, (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        Map dataStreams = clusterState.metadata().dataStreams();
        return results.stream().map(dataStreams::get).sorted(Comparator.comparing(DataStream::getName)).toList();
    }

    protected ClusterBlockException checkBlock(GetDataStreamAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

