/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class MultiTypeEsField
extends EsField {
    private final Map<String, Expression> indexToConversionExpressions;

    public MultiTypeEsField(String name, DataType dataType, boolean aggregatable, Map<String, Expression> indexToConversionExpressions) {
        super(name, dataType, Map.of(), aggregatable);
        this.indexToConversionExpressions = indexToConversionExpressions;
    }

    protected MultiTypeEsField(StreamInput in) throws IOException {
        this(((PlanStreamInput)in).readCachedString(), DataType.readFrom(in), in.readBoolean(), in.readImmutableMap(i -> (Expression)i.readNamedWriteable(Expression.class)));
    }

    @Override
    public void writeContent(StreamOutput out) throws IOException {
        ((PlanStreamOutput)out).writeCachedString(this.getName());
        this.getDataType().writeTo(out);
        out.writeBoolean(this.isAggregatable());
        out.writeMap(this.getIndexToConversionExpressions(), (o, v) -> out.writeNamedWriteable((NamedWriteable)v));
    }

    @Override
    public String getWriteableName() {
        return "MultiTypeEsField";
    }

    public Map<String, Expression> getIndexToConversionExpressions() {
        return this.indexToConversionExpressions;
    }

    public Expression getConversionExpressionForIndex(String indexName) {
        return this.indexToConversionExpressions.get(indexName);
    }

    public static MultiTypeEsField resolveFrom(InvalidMappedField invalidMappedField, Map<String, Expression> typesToConversionExpressions) {
        Map<String, Set<String>> typesToIndices = invalidMappedField.getTypesToIndices();
        DataType resolvedDataType = DataType.UNSUPPORTED;
        HashMap<String, Expression> indexToConversionExpressions = new HashMap<String, Expression>();
        for (String typeName : typesToIndices.keySet()) {
            Set<String> indices = typesToIndices.get(typeName);
            Expression convertExpr = typesToConversionExpressions.get(typeName);
            if (resolvedDataType == DataType.UNSUPPORTED) {
                resolvedDataType = convertExpr.dataType();
            } else if (resolvedDataType != convertExpr.dataType()) {
                throw new IllegalArgumentException("Resolved data type mismatch: " + resolvedDataType + " != " + convertExpr.dataType());
            }
            for (String indexName : indices) {
                indexToConversionExpressions.put(indexName, convertExpr);
            }
        }
        return new MultiTypeEsField(invalidMappedField.getName(), resolvedDataType, false, indexToConversionExpressions);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof MultiTypeEsField) {
            MultiTypeEsField other = (MultiTypeEsField)obj;
            return super.equals(other) && this.indexToConversionExpressions.equals(other.indexToConversionExpressions);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indexToConversionExpressions);
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.indexToConversionExpressions + ")";
    }
}

