/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.type;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class InvalidMappedField
extends EsField {
    private final String errorMessage;
    private final Map<String, Set<String>> typesToIndices;

    public InvalidMappedField(String name, String errorMessage, Map<String, EsField> properties) {
        this(name, errorMessage, properties, Map.of());
    }

    public InvalidMappedField(String name, String errorMessage) {
        this(name, errorMessage, new TreeMap<String, EsField>());
    }

    public InvalidMappedField(String name, Map<String, Set<String>> typesToIndices) {
        this(name, InvalidMappedField.makeErrorMessage(typesToIndices), new TreeMap<String, EsField>(), typesToIndices);
    }

    private InvalidMappedField(String name, String errorMessage, Map<String, EsField> properties, Map<String, Set<String>> typesToIndices) {
        super(name, DataType.UNSUPPORTED, properties, false);
        this.errorMessage = errorMessage;
        this.typesToIndices = typesToIndices;
    }

    protected InvalidMappedField(StreamInput in) throws IOException {
        this(((PlanStreamInput)in).readCachedString(), in.readString(), in.readImmutableMap(StreamInput::readString, EsField::readFrom));
    }

    public Set<DataType> types() {
        return this.typesToIndices.keySet().stream().map(DataType::fromTypeName).collect(Collectors.toSet());
    }

    @Override
    public void writeContent(StreamOutput out) throws IOException {
        ((PlanStreamOutput)out).writeCachedString(this.getName());
        out.writeString(this.errorMessage);
        out.writeMap(this.getProperties(), (o, x) -> x.writeTo(out));
    }

    @Override
    public String getWriteableName() {
        return "InvalidMappedField";
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.errorMessage);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            InvalidMappedField other = (InvalidMappedField)obj;
            return Objects.equals(this.errorMessage, other.errorMessage);
        }
        return false;
    }

    @Override
    public EsField getExactField() {
        throw new QlIllegalArgumentException("Field [" + this.getName() + "] is invalid, cannot access it");
    }

    @Override
    public EsField.Exact getExactInfo() {
        return new EsField.Exact(false, "Field [" + this.getName() + "] is invalid, cannot access it");
    }

    public Map<String, Set<String>> getTypesToIndices() {
        return this.typesToIndices;
    }

    private static String makeErrorMessage(Map<String, Set<String>> typesToIndices) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("mapped as [");
        errorMessage.append(typesToIndices.size());
        errorMessage.append("] incompatible types: ");
        boolean first = true;
        for (Map.Entry<String, Set<String>> e : typesToIndices.entrySet()) {
            if (first) {
                first = false;
            } else {
                errorMessage.append(", ");
            }
            errorMessage.append("[");
            errorMessage.append(e.getKey());
            errorMessage.append("] in ");
            if (e.getValue().size() <= 3) {
                errorMessage.append(e.getValue());
                continue;
            }
            errorMessage.append(e.getValue().stream().sorted().limit(3L).collect(Collectors.toList()));
            errorMessage.append(" and [" + (e.getValue().size() - 3) + "] other ");
            errorMessage.append(e.getValue().size() == 4 ? "index" : "indices");
        }
        return errorMessage.toString();
    }
}

