/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression.predicate.fulltext;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.fulltext.FullTextPredicate;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class MatchQueryPredicate
extends FullTextPredicate {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "MatchQueryPredicate", MatchQueryPredicate::new);
    private final Expression field;

    public MatchQueryPredicate(Source source, Expression field, String query, String options) {
        super(source, query, options, Collections.singletonList(field));
        this.field = field;
    }

    MatchQueryPredicate(StreamInput in) throws IOException {
        super(in);
        assert (super.children().size() == 1);
        this.field = (Expression)super.children().get(0);
    }

    @Override
    protected NodeInfo<MatchQueryPredicate> info() {
        return NodeInfo.create(this, MatchQueryPredicate::new, this.field, this.query(), this.options());
    }

    @Override
    public MatchQueryPredicate replaceChildren(List<Expression> newChildren) {
        return new MatchQueryPredicate(this.source(), newChildren.get(0), this.query(), this.options());
    }

    public Expression field() {
        return this.field;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            MatchQueryPredicate other = (MatchQueryPredicate)obj;
            return Objects.equals(this.field, other.field);
        }
        return false;
    }

    public String getWriteableName() {
        return MatchQueryPredicate.ENTRY.name;
    }
}

