/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class NamedExpression
extends Expression
implements NamedWriteable {
    private final String name;
    private final NameId id;
    private final boolean synthetic;

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        for (NamedWriteableRegistry.Entry e : Attribute.getNamedWriteables()) {
            entries.add(new NamedWriteableRegistry.Entry(NamedExpression.class, e.name, in -> (NamedExpression)e.reader.read(in)));
        }
        entries.add(Alias.ENTRY);
        return entries;
    }

    public NamedExpression(Source source, String name, List<Expression> children, NameId id) {
        this(source, name, children, id, false);
    }

    public NamedExpression(Source source, String name, List<Expression> children, NameId id, boolean synthetic) {
        super(source, children);
        this.name = name;
        this.id = id == null ? new NameId() : id;
        this.synthetic = synthetic;
    }

    public String name() {
        return this.name;
    }

    public NameId id() {
        return this.id;
    }

    public boolean synthetic() {
        return this.synthetic;
    }

    public abstract Attribute toAttribute();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.synthetic);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedExpression other = (NamedExpression)obj;
        return Objects.equals(this.synthetic, other.synthetic) && Objects.equals(this.name, other.name) && Objects.equals(this.children(), other.children());
    }

    @Override
    public String toString() {
        return super.toString() + "#" + this.id();
    }

    @Override
    public String nodeString() {
        return this.name();
    }
}

