/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;
import org.elasticsearch.xpack.esql.core.util.PlanStreamOutput;

public class FieldAttribute
extends TypedAttribute {
    static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Attribute.class, "FieldAttribute", FieldAttribute::readFrom);
    private final FieldAttribute parent;
    private final String path;
    private final EsField field;

    public FieldAttribute(Source source, String name, EsField field) {
        this(source, null, name, field);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field) {
        this(source, parent, name, field, Nullability.TRUE, null, false);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field, boolean synthetic) {
        this(source, parent, name, field, Nullability.TRUE, null, synthetic);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field, Nullability nullability, NameId id, boolean synthetic) {
        this(source, parent, name, field.getDataType(), field, nullability, id, synthetic);
    }

    FieldAttribute(Source source, FieldAttribute parent, String name, DataType type, EsField field, Nullability nullability, NameId id, boolean synthetic) {
        super(source, name, type, nullability, id, synthetic);
        this.path = parent != null ? parent.name() : "";
        this.parent = parent;
        this.field = field;
    }

    @Deprecated
    private FieldAttribute(Source source, FieldAttribute parent, String name, DataType type, EsField field, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        this(source, parent, name, type, field, nullability, id, synthetic);
    }

    private FieldAttribute(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (FieldAttribute)in.readOptionalWriteable(FieldAttribute::readFrom), ((PlanStreamInput)in).readCachedString(), DataType.readFrom(in), (EsField)EsField.readFrom(in), in.readOptionalString(), (Nullability)in.readEnum(Nullability.class), NameId.readFrom((StreamInput)((PlanStreamInput)in)), in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (((PlanStreamOutput)out).writeAttributeCacheHeader(this)) {
            Source.EMPTY.writeTo(out);
            out.writeOptionalWriteable((Writeable)this.parent);
            ((PlanStreamOutput)out).writeCachedString(this.name());
            this.dataType().writeTo(out);
            this.field.writeTo(out);
            out.writeOptionalString(null);
            out.writeEnum((Enum)this.nullable());
            this.id().writeTo(out);
            out.writeBoolean(this.synthetic());
        }
    }

    public static FieldAttribute readFrom(StreamInput in) throws IOException {
        return (FieldAttribute)((PlanStreamInput)in).readAttributeWithCache(FieldAttribute::new);
    }

    public String getWriteableName() {
        return FieldAttribute.ENTRY.name;
    }

    @Override
    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create(this, FieldAttribute::new, this.parent, this.name(), this.dataType(), this.field, null, this.nullable(), this.id(), this.synthetic());
    }

    public FieldAttribute parent() {
        return this.parent;
    }

    public String path() {
        return this.path;
    }

    public String fieldName() {
        if (!(this.synthetic() || this.name().startsWith("$$"))) {
            return this.name();
        }
        return Strings.hasText((String)this.path) ? this.path + "." + this.field.getName() : this.field.getName();
    }

    public EsField.Exact getExactInfo() {
        return this.field.getExactInfo();
    }

    public FieldAttribute exactAttribute() {
        EsField exactField = this.field.getExactField();
        if (!exactField.equals(this.field)) {
            return this.innerField(exactField);
        }
        return this;
    }

    private FieldAttribute innerField(EsField type) {
        return new FieldAttribute(this.source(), this, this.name() + "." + type.getName(), type, this.nullable(), this.id(), this.synthetic());
    }

    @Override
    protected Attribute clone(Source source, String name, DataType type, Nullability nullability, NameId id, boolean synthetic) {
        return new FieldAttribute(source, this.parent, name, this.field, nullability, id, synthetic);
    }

    @Override
    public Attribute withDataType(DataType type) {
        throw new UnsupportedOperationException("FieldAttribute obtains its type from the contained EsField.");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path, this.field);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.path, ((FieldAttribute)obj).path) && Objects.equals(this.field, ((FieldAttribute)obj).field);
    }

    @Override
    protected String label() {
        return "f";
    }

    public EsField field() {
        return this.field;
    }
}

