/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.PlanStreamInput;

public final class Alias
extends NamedExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(NamedExpression.class, "Alias", Alias::new);
    private final Expression child;
    private Attribute lazyAttribute;

    public Alias(Source source, String name, Expression child) {
        this(source, name, child, null);
    }

    public Alias(Source source, String name, Expression child, NameId id) {
        this(source, name, child, id, false);
    }

    public Alias(Source source, String name, Expression child, NameId id, boolean synthetic) {
        super(source, name, Collections.singletonList(child), id, synthetic);
        this.child = child;
    }

    @Deprecated
    private Alias(Source source, String name, String qualifier, Expression child, NameId id, boolean synthetic) {
        this(source, name, child, id, synthetic);
    }

    public Alias(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), in.readString(), in.readOptionalString(), (Expression)in.readNamedWriteable(Expression.class), NameId.readFrom((StreamInput)((PlanStreamInput)in)), in.readBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeString(this.name());
        out.writeOptionalString(null);
        out.writeNamedWriteable((NamedWriteable)this.child());
        this.id().writeTo(out);
        out.writeBoolean(this.synthetic());
    }

    public String getWriteableName() {
        return Alias.ENTRY.name;
    }

    @Override
    protected NodeInfo<Alias> info() {
        return NodeInfo.create(this, Alias::new, this.name(), this.child, this.id(), this.synthetic());
    }

    public Alias replaceChild(Expression child) {
        return new Alias(this.source(), this.name(), child, this.id(), this.synthetic());
    }

    @Override
    public Alias replaceChildren(List<Expression> newChildren) {
        return new Alias(this.source(), this.name(), newChildren.get(0), this.id(), this.synthetic());
    }

    public Expression child() {
        return this.child;
    }

    @Override
    public Nullability nullable() {
        return this.child.nullable();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.child.resolveType();
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Attribute toAttribute() {
        if (this.lazyAttribute == null) {
            this.lazyAttribute = this.resolved() ? new ReferenceAttribute(this.source(), this.name(), this.dataType(), this.nullable(), this.id(), this.synthetic()) : new UnresolvedAttribute(this.source(), this.name());
        }
        return this.lazyAttribute;
    }

    @Override
    public String toString() {
        return this.child + " AS " + this.name() + "#" + this.id();
    }

    @Override
    public String nodeString() {
        return this.child.nodeString() + " AS " + this.name();
    }

    public static Expression unwrap(Expression e) {
        Expression expression;
        if (e instanceof Alias) {
            Alias as = (Alias)e;
            expression = as.child();
        } else {
            expression = e;
        }
        return expression;
    }
}

