/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;

abstract class LabelFieldProducer
extends AbstractDownsampleFieldProducer {
    LabelFieldProducer(String name) {
        super(name);
    }

    abstract Label label();

    public static class HistogramLastLabelFieldProducer
    extends LabelLastValueFieldProducer {
        HistogramLastLabelFieldProducer(String name) {
            super(name);
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                HistogramValue histogramValue = (HistogramValue)this.label.get();
                ArrayList<Double> values = new ArrayList<Double>();
                ArrayList<Long> counts = new ArrayList<Long>();
                while (histogramValue.next()) {
                    values.add(histogramValue.value());
                    counts.add(histogramValue.count());
                }
                builder.startObject(this.name()).field("counts", counts).field("values", values).endObject();
            }
        }
    }

    static class AggregateMetricFieldProducer
    extends LabelLastValueFieldProducer {
        AggregateMetricFieldProducer(String name, AggregateDoubleMetricFieldMapper.Metric metric) {
            super(name, new LastValueLabel(metric.name()));
        }
    }

    static class LabelLastValueFieldProducer
    extends LabelFieldProducer {
        protected final LastValueLabel label;

        LabelLastValueFieldProducer(String name, LastValueLabel label) {
            super(name);
            this.label = label;
        }

        LabelLastValueFieldProducer(String name) {
            this(name, new LastValueLabel());
        }

        @Override
        Label label() {
            return this.label;
        }

        @Override
        public void write(XContentBuilder builder) throws IOException {
            if (!this.isEmpty()) {
                builder.field(this.name(), this.label.get());
            }
        }

        @Override
        public void collect(FormattedDocValues docValues, int docId) throws IOException {
            if (!this.isEmpty()) {
                return;
            }
            if (!docValues.advanceExact(docId)) {
                return;
            }
            int docValuesCount = docValues.docValueCount();
            assert (docValuesCount > 0);
            this.isEmpty = false;
            if (docValuesCount == 1) {
                this.label.collect(docValues.nextValue());
            } else {
                Object[] values = new Object[docValuesCount];
                for (int i = 0; i < docValuesCount; ++i) {
                    values[i] = docValues.nextValue();
                }
                this.label.collect(values);
            }
        }

        @Override
        public void reset() {
            this.label.reset();
            this.isEmpty = true;
        }
    }

    static final class LastValueLabel
    extends Label {
        private Object lastValue;

        LastValueLabel(String name) {
            super(name);
        }

        LastValueLabel() {
            this("last_value");
        }

        @Override
        Object get() {
            return this.lastValue;
        }

        @Override
        void reset() {
            this.lastValue = null;
        }

        @Override
        void collect(Object value) {
            if (this.lastValue == null) {
                this.lastValue = value;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class Label {
        private final String name;

        protected Label(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        abstract void collect(Object var1);

        abstract Object get();

        abstract void reset();
    }
}

