/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.util.Check;

public class LocateFunctionProcessor
implements Processor {
    private final Processor pattern;
    private final Processor input;
    private final Processor start;
    public static final String NAME = "sloc";

    public LocateFunctionProcessor(Processor pattern, Processor input, Processor start) {
        this.pattern = pattern;
        this.input = input;
        this.start = start;
    }

    public LocateFunctionProcessor(StreamInput in) throws IOException {
        this.pattern = (Processor)in.readNamedWriteable(Processor.class);
        this.input = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readOptionalNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.pattern);
        out.writeNamedWriteable((NamedWriteable)this.input);
        out.writeOptionalNamedWriteable((NamedWriteable)this.start);
    }

    public Object process(Object input) {
        return LocateFunctionProcessor.doProcess(this.pattern().process(input), this.input().process(input), this.start() == null ? null : this.start().process(input));
    }

    public static Integer doProcess(Object pattern, Object input, Object start) {
        if (pattern == null || input == null) {
            return null;
        }
        if (!(input instanceof String || input instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", input);
        }
        if (!(pattern instanceof String || pattern instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", pattern);
        }
        if (start != null) {
            Check.isFixedNumberAndInRange(start, "start", -2147483647L, Integer.MAX_VALUE);
        }
        String stringInput = input instanceof Character ? input.toString() : (String)input;
        String stringPattern = pattern instanceof Character ? pattern.toString() : (String)pattern;
        int startIndex = start == null ? 0 : ((Number)start).intValue() - 1;
        return 1 + stringInput.indexOf(stringPattern, startIndex);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocateFunctionProcessor other = (LocateFunctionProcessor)obj;
        return Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.start(), other.start());
    }

    public int hashCode() {
        return Objects.hash(this.pattern(), this.input(), this.start());
    }

    public Processor pattern() {
        return this.pattern;
    }

    public Processor input() {
        return this.input;
    }

    public Processor start() {
        return this.start;
    }

    public String getWriteableName() {
        return NAME;
    }
}

