/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.common.io.SqlStreamInput;

public abstract class ThreeArgsDateTimeProcessor
implements Processor {
    private final Processor first;
    private final Processor second;
    private final Processor third;
    private final ZoneId zoneId;

    public ThreeArgsDateTimeProcessor(Processor first, Processor second, Processor third, ZoneId zoneId) {
        this.first = first;
        this.second = second;
        this.third = third;
        this.zoneId = zoneId;
    }

    protected ThreeArgsDateTimeProcessor(StreamInput in) throws IOException {
        this.first = (Processor)in.readNamedWriteable(Processor.class);
        this.second = (Processor)in.readNamedWriteable(Processor.class);
        this.third = (Processor)in.readNamedWriteable(Processor.class);
        this.zoneId = SqlStreamInput.asSqlStream(in).zoneId();
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.first);
        out.writeNamedWriteable((NamedWriteable)this.second);
        out.writeNamedWriteable((NamedWriteable)this.third);
    }

    public Processor first() {
        return this.first;
    }

    public Processor second() {
        return this.second;
    }

    public Processor third() {
        return this.third;
    }

    ZoneId zoneId() {
        return this.zoneId;
    }

    public Object process(Object input) {
        Object o1 = this.first().process(input);
        if (o1 == null) {
            return null;
        }
        Object o2 = this.second().process(input);
        if (o2 == null) {
            return null;
        }
        Object o3 = this.third().process(input);
        if (o3 == null) {
            return null;
        }
        return this.doProcess(o1, o2, o3, this.zoneId());
    }

    public abstract Object doProcess(Object var1, Object var2, Object var3, ZoneId var4);

    public int hashCode() {
        return Objects.hash(this.first, this.second, this.third, this.zoneId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeArgsDateTimeProcessor that = (ThreeArgsDateTimeProcessor)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second) && Objects.equals(this.third, that.third) && Objects.equals(this.zoneId, that.zoneId);
    }
}

