/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.metrics.PercentilesMethod;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.TwoOptionalArguments;
import org.elasticsearch.xpack.ql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;

abstract class PercentileAggregate
extends NumericAggregate
implements EnclosedAgg,
TwoOptionalArguments {
    private static final PercentilesConfig.TDigest DEFAULT_PERCENTILES_CONFIG = new PercentilesConfig.TDigest();
    private static final Map<String, MethodConfigurator> METHOD_CONFIGURATORS = new LinkedHashMap<String, MethodConfigurator>();
    private final Expression parameter;
    private final Expression method;
    private final Expression methodParameter;

    PercentileAggregate(Source source, Expression field, Expression parameter, Expression method, Expression methodParameter) {
        super(source, field, Collections.singletonList(parameter));
        this.parameter = parameter;
        this.method = method;
        this.methodParameter = methodParameter;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isFoldable((Expression)this.parameter, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isNumeric((Expression)this.parameter, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        TypeResolutions.ParamOrdinal methodOrdinal = TypeResolutions.ParamOrdinal.fromIndex((int)(this.parameters().size() + 1));
        TypeResolutions.ParamOrdinal methodParameterOrdinal = TypeResolutions.ParamOrdinal.fromIndex((int)(this.parameters().size() + 2));
        if (this.method != null) {
            resolution = TypeResolutions.isFoldable((Expression)this.method, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)methodOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = TypeResolutions.isString((Expression)this.method, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)methodOrdinal);
            if (resolution.unresolved()) {
                return resolution;
            }
            String methodName = (String)this.method.fold();
            MethodConfigurator methodConfigurator = METHOD_CONFIGURATORS.get(methodName);
            if (methodConfigurator == null) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{}argument of [{}] must be one of {}, received [{}]", (Object[])new Object[]{methodOrdinal.name().toLowerCase(Locale.ROOT) + " ", this.sourceText(), METHOD_CONFIGURATORS.keySet(), methodName}));
            }
            if (this.methodParameter != null && !Expressions.isNull((Expression)this.methodParameter)) {
                resolution = TypeResolutions.isFoldable((Expression)this.methodParameter, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)methodParameterOrdinal);
                if (resolution.unresolved()) {
                    return resolution;
                }
                resolution = methodConfigurator.resolver.resolve(this.methodParameter, this.sourceText(), methodParameterOrdinal);
                return resolution;
            }
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression parameter() {
        return this.parameter;
    }

    public Expression method() {
        return this.method;
    }

    public Expression methodParameter() {
        return this.methodParameter;
    }

    public String innerName() {
        Double value = (Double)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)this.parameter), DataTypes.DOUBLE);
        return Double.toString(value);
    }

    public PercentilesConfig percentilesConfig() {
        if (this.method == null) {
            return DEFAULT_PERCENTILES_CONFIG;
        }
        String methodName = (String)PercentileAggregate.foldNullSafe(this.method, DataTypes.KEYWORD);
        MethodConfigurator methodConfigurator = METHOD_CONFIGURATORS.get(methodName);
        if (methodConfigurator == null) {
            throw new IllegalStateException("Not handled PercentilesMethod [" + methodName + "], type resolution needs fix");
        }
        return methodConfigurator.parameterToConfig.apply(this.methodParameter);
    }

    private static <T> T foldNullSafe(Expression e, DataType dataType) {
        return (T)(e == null ? null : SqlDataTypeConverter.convert(Foldables.valueOf((Expression)e), dataType));
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.method, this.methodParameter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        PercentileAggregate that = (PercentileAggregate)((Object)o);
        return Objects.equals(this.method, that.method) && Objects.equals(this.methodParameter, that.methodParameter);
    }

    static {
        Arrays.asList(new MethodConfigurator(PercentilesMethod.TDIGEST, TypeResolutions::isNumeric, methodParameter -> {
            Double compression = (Double)PercentileAggregate.foldNullSafe(methodParameter, DataTypes.DOUBLE);
            return compression == null ? new PercentilesConfig.TDigest() : new PercentilesConfig.TDigest(compression.doubleValue());
        }), new MethodConfigurator(PercentilesMethod.HDR, TypeResolutions::isInteger, methodParameter -> {
            Integer numOfDigits = (Integer)PercentileAggregate.foldNullSafe(methodParameter, DataTypes.INTEGER);
            return numOfDigits == null ? new PercentilesConfig.Hdr() : new PercentilesConfig.Hdr(numOfDigits.intValue());
        })).forEach(c -> METHOD_CONFIGURATORS.put(c.method.getParseField().getPreferredName(), (MethodConfigurator)c));
    }

    private static class MethodConfigurator {
        private final PercentilesMethod method;
        private final MethodParameterResolver resolver;
        private final Function<Expression, PercentilesConfig> parameterToConfig;

        MethodConfigurator(PercentilesMethod method, MethodParameterResolver resolver, Function<Expression, PercentilesConfig> parameterToConfig) {
            this.method = method;
            this.resolver = resolver;
            this.parameterToConfig = parameterToConfig;
        }

        @FunctionalInterface
        private static interface MethodParameterResolver {
            public Expression.TypeResolution resolve(Expression var1, String var2, TypeResolutions.ParamOrdinal var3);
        }
    }
}

