/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.analysis.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xpack.ql.analyzer.AnalyzerRules;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAlias;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.FunctionResolutionStrategy;
import org.elasticsearch.xpack.ql.expression.function.Functions;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.index.IndexResolution;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnresolvedRelation;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.sql.analysis.analyzer.AnalyzerContext;
import org.elasticsearch.xpack.sql.analysis.analyzer.VerificationException;
import org.elasticsearch.xpack.sql.analysis.analyzer.Verifier;
import org.elasticsearch.xpack.sql.expression.SubQueryExpression;
import org.elasticsearch.xpack.sql.expression.function.SqlFunctionResolution;
import org.elasticsearch.xpack.sql.expression.function.scalar.Cast;
import org.elasticsearch.xpack.sql.plan.logical.Join;
import org.elasticsearch.xpack.sql.plan.logical.LocalRelation;
import org.elasticsearch.xpack.sql.plan.logical.Pivot;
import org.elasticsearch.xpack.sql.plan.logical.SubQueryAlias;
import org.elasticsearch.xpack.sql.plan.logical.With;

public final class Analyzer
extends ParameterizedRuleExecutor<LogicalPlan, AnalyzerContext> {
    private static final Iterable<RuleExecutor.Batch<LogicalPlan>> rules;
    private final Verifier verifier;

    public Analyzer(AnalyzerContext context, Verifier verifier) {
        super((Object)context);
        context.analyzeWithoutVerify().set(x$0 -> (LogicalPlan)this.execute((Node)x$0));
        this.verifier = verifier;
    }

    protected Iterable<RuleExecutor.Batch<LogicalPlan>> batches() {
        return rules;
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        return this.analyze(plan, true);
    }

    public LogicalPlan analyze(LogicalPlan plan, boolean verify) {
        if (plan.analyzed()) {
            return plan;
        }
        return verify ? this.verify((LogicalPlan)this.execute((Node)plan)) : (LogicalPlan)this.execute((Node)plan);
    }

    public RuleExecutor.ExecutionInfo debugAnalyze(LogicalPlan plan) {
        return plan.analyzed() ? null : this.executeWithInfo((Node)plan);
    }

    public LogicalPlan verify(LogicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan, ((AnalyzerContext)this.context()).configuration().version());
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    private static <E extends Expression> E resolveExpression(E expression, LogicalPlan plan) {
        return (E)((Expression)expression.transformUp(e -> {
            if (e instanceof UnresolvedAttribute) {
                UnresolvedAttribute ua = (UnresolvedAttribute)e;
                Attribute a = Analyzer.resolveAgainstList(ua, plan.output());
                return a != null ? a : e;
            }
            return e;
        }));
    }

    private static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList) {
        return Analyzer.resolveAgainstList(u, attrList, false);
    }

    private static Attribute resolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, boolean allowCompound) {
        List matches = AnalyzerRules.maybeResolveAgainstList((UnresolvedAttribute)u, attrList, a -> AnalyzerRules.handleSpecialFields((UnresolvedAttribute)u, (Attribute)a, (boolean)allowCompound));
        return matches.isEmpty() ? null : (Attribute)matches.get(0);
    }

    private static boolean hasStar(List<? extends Expression> exprs) {
        for (Expression expression : exprs) {
            if (!(expression instanceof UnresolvedStar)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsAggregate(List<? extends Expression> list) {
        return Expressions.anyMatch(list, Functions::isAggregate);
    }

    private static boolean containsAggregate(Expression exp) {
        return Analyzer.containsAggregate(Collections.singletonList(exp));
    }

    static {
        RuleExecutor.Batch substitution = new RuleExecutor.Batch("Substitution", new Rule[]{new CTESubstitution()});
        RuleExecutor.Batch resolution = new RuleExecutor.Batch("Resolution", new Rule[]{new ResolveTable(), new ResolveRefs(), new ResolveOrdinalInOrderByAndGroupBy(), new ResolveMissingRefs(), new ResolveFilterRefs(), new ResolveFunctions(), new ResolveAliases(), new ProjectedAggregations(), new HavingOverProject(), new ResolveAggsInHaving(), new ResolveAggsInOrderBy()});
        RuleExecutor.Batch finish = new RuleExecutor.Batch("Finish Analysis", new Rule[]{new ReplaceSubQueryAliases(), new PruneSubQueryAliases(), new AnalyzerRules.AddMissingEqualsToBoolField(), CleanAliases.INSTANCE});
        rules = Arrays.asList(substitution, resolution, finish);
    }

    private static class CTESubstitution
    extends AnalyzerRules.AnalyzerRule<With> {
        private CTESubstitution() {
        }

        protected LogicalPlan rule(With plan) {
            return CTESubstitution.substituteCTE(plan.child(), plan.subQueries());
        }

        private static LogicalPlan substituteCTE(LogicalPlan p, Map<String, SubQueryAlias> subQueries) {
            if (p instanceof UnresolvedRelation) {
                UnresolvedRelation ur = (UnresolvedRelation)p;
                SubQueryAlias subQueryAlias = subQueries.get(ur.table().index());
                if (subQueryAlias != null) {
                    if (ur.alias() != null) {
                        return new SubQueryAlias(ur.source(), (LogicalPlan)subQueryAlias, ur.alias());
                    }
                    return subQueryAlias;
                }
                return ur;
            }
            if (p instanceof LocalRelation) {
                return p;
            }
            return (LogicalPlan)p.transformExpressionsDown(SubQueryExpression.class, sq -> sq.withQuery(CTESubstitution.substituteCTE(sq.query(), subQueries)));
        }

        protected boolean skipResolved() {
            return false;
        }
    }

    private static class ResolveTable
    extends AnalyzerRules.ParameterizedAnalyzerRule<UnresolvedRelation, AnalyzerContext> {
        private ResolveTable() {
        }

        protected LogicalPlan rule(UnresolvedRelation plan, AnalyzerContext context) {
            IndexResolution indexResolution = context.indexResolution();
            if (!indexResolution.isValid()) {
                return plan.unresolvedMessage().equals(indexResolution.toString()) ? plan : new UnresolvedRelation(plan.source(), plan.table(), plan.alias(), plan.frozen(), indexResolution.toString());
            }
            TableIdentifier table = plan.table();
            if (!indexResolution.matches(table.index())) {
                new UnresolvedRelation(plan.source(), plan.table(), plan.alias(), plan.frozen(), "invalid [" + table + "] resolution to [" + indexResolution + "]");
            }
            EsRelation logicalPlan = new EsRelation(plan.source(), indexResolution.get(), plan.frozen());
            SubQueryAlias sa = new SubQueryAlias(plan.source(), (LogicalPlan)logicalPlan, indexResolution.get().toString());
            if (plan.alias() != null) {
                sa = new SubQueryAlias(plan.source(), (LogicalPlan)sa, plan.alias());
            }
            return sa;
        }
    }

    private static class ResolveRefs
    extends AnalyzerRules.BaseAnalyzerRule {
        private ResolveRefs() {
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            OrderBy o;
            if (plan instanceof Project) {
                Project p = (Project)plan;
                if (Analyzer.hasStar(p.projections())) {
                    return new Project(p.source(), p.child(), ResolveRefs.expandProjections(p.projections(), p.child()));
                }
            } else if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (Analyzer.hasStar(a.aggregates())) {
                    return new Aggregate(a.source(), a.child(), a.groupings(), ResolveRefs.expandProjections(a.aggregates(), a.child()));
                }
                if (!a.expressionsResolved() && Resolvables.resolved((Iterable)a.aggregates())) {
                    List groupings = a.groupings();
                    ArrayList<Expression> newGroupings = new ArrayList<Expression>();
                    List resolvedAliases = Expressions.aliases((List)a.aggregates());
                    boolean changed = false;
                    for (Object grouping : groupings) {
                        Attribute maybeResolved;
                        if (grouping instanceof UnresolvedAttribute && (maybeResolved = Analyzer.resolveAgainstList((UnresolvedAttribute)grouping, resolvedAliases.stream().map(Tuple::v1).collect(Collectors.toList()))) != null) {
                            changed = true;
                            grouping = maybeResolved.resolved() ? resolvedAliases.stream().filter(t -> ((Attribute)t.v1()).equals((Object)maybeResolved)).map(Tuple::v2).findAny().get() : maybeResolved;
                        }
                        newGroupings.add((Expression)grouping);
                    }
                    return changed ? new Aggregate(a.source(), a.child(), newGroupings, a.aggregates()) : a;
                }
            } else if (plan instanceof Join) {
                Join j = (Join)plan;
                if (!j.duplicatesResolved()) {
                    LogicalPlan deduped = this.dedupRight(j.left(), j.right());
                    return new Join(j.source(), j.left(), deduped, j.type(), j.condition());
                }
            } else if (plan instanceof OrderBy && !(o = (OrderBy)plan).resolved()) {
                ArrayList<Order> resolvedOrder = new ArrayList<Order>(o.order().size());
                for (Order order : o.order()) {
                    resolvedOrder.add(Analyzer.resolveExpression(order, o.child()));
                }
                return new OrderBy(o.source(), o.child(), resolvedOrder);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to resolve {}", (Object)plan.nodeString());
            }
            return (LogicalPlan)plan.transformExpressionsUp(UnresolvedAttribute.class, u -> {
                ArrayList<Attribute> childrenOutput = new ArrayList<Attribute>();
                for (LogicalPlan child : plan.children()) {
                    childrenOutput.addAll(child.output());
                }
                Attribute named = Analyzer.resolveAgainstList(u, childrenOutput);
                if (named != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Resolved {} to {}", u, (Object)named);
                    }
                    return named;
                }
                return u;
            });
        }

        private static List<NamedExpression> expandProjections(List<? extends NamedExpression> projections, LogicalPlan child) {
            ArrayList<NamedExpression> result = new ArrayList<NamedExpression>();
            List output = child.output();
            for (NamedExpression namedExpression : projections) {
                if (namedExpression instanceof UnresolvedStar) {
                    List<NamedExpression> expanded = ResolveRefs.expandStar((UnresolvedStar)namedExpression, output);
                    result.addAll(expanded);
                    continue;
                }
                if (namedExpression instanceof UnresolvedAlias) {
                    UnresolvedAlias ua = (UnresolvedAlias)namedExpression;
                    if (!(ua.child() instanceof UnresolvedStar)) continue;
                    result.addAll(ResolveRefs.expandStar((UnresolvedStar)ua.child(), output));
                    continue;
                }
                result.add(namedExpression);
            }
            return result;
        }

        private static List<NamedExpression> expandStar(UnresolvedStar us, List<Attribute> output) {
            ArrayList<NamedExpression> expanded = new ArrayList<NamedExpression>();
            if (us.qualifier() != null) {
                Attribute q = Analyzer.resolveAgainstList(us.qualifier(), output, true);
                if (q == null) {
                    return Collections.singletonList(us.qualifier());
                }
                if (!q.resolved()) {
                    return Collections.singletonList(q);
                }
                if (DataTypes.isPrimitive((DataType)q.dataType())) {
                    return Collections.singletonList(us);
                }
                for (Attribute attr : output) {
                    FieldAttribute fa;
                    if (!(attr instanceof FieldAttribute) || DataTypes.isUnsupported((DataType)(fa = (FieldAttribute)attr).dataType())) continue;
                    if (q.qualifier() != null) {
                        if (!Objects.equals(q.qualifiedName(), fa.qualifiedPath())) continue;
                        expanded.add((NamedExpression)fa.withLocation(attr.source()));
                        continue;
                    }
                    if (!Objects.equals(q.name(), fa.path())) continue;
                    expanded.add((NamedExpression)fa.withLocation(attr.source()));
                }
            } else {
                expanded.addAll(Expressions.onlyPrimitiveFieldAttributes(output));
            }
            return expanded;
        }

        private LogicalPlan dedupRight(LogicalPlan left, LogicalPlan right) {
            AttributeSet conflicting = left.outputSet().intersect(right.outputSet());
            if (this.log.isTraceEnabled()) {
                this.log.trace("Trying to resolve conflicts " + conflicting + " between left " + left.nodeString() + " and right " + right.nodeString());
            }
            throw new UnsupportedOperationException("don't know how to resolve conficting IDs yet");
        }
    }

    private static class ResolveOrdinalInOrderByAndGroupBy
    extends AnalyzerRules.BaseAnalyzerRule {
        private ResolveOrdinalInOrderByAndGroupBy() {
        }

        protected boolean skipResolved() {
            return false;
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            if (plan instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)plan;
                boolean changed = false;
                ArrayList<Order> newOrder = new ArrayList<Order>(orderBy.order().size());
                List ordinalReference = orderBy.child().output();
                int max = ordinalReference.size();
                for (Order order : orderBy.order()) {
                    Expression child = order.child();
                    Integer ordinal = ResolveOrdinalInOrderByAndGroupBy.findOrdinal(order.child());
                    if (ordinal != null) {
                        changed = true;
                        if (ordinal > 0 && ordinal <= max) {
                            newOrder.add(new Order(order.source(), (Expression)orderBy.child().output().get(ordinal - 1), order.direction(), order.nullsPosition()));
                            continue;
                        }
                        String message = LoggerMessageFormat.format((String)"Invalid ordinal [{}] specified in [{}] (valid range is [1, {}])", (Object[])new Object[]{ordinal, orderBy.sourceText(), max});
                        UnresolvedAttribute ua = new UnresolvedAttribute(child.source(), orderBy.sourceText(), null, message);
                        newOrder.add(new Order(order.source(), (Expression)ua, order.direction(), order.nullsPosition()));
                        continue;
                    }
                    newOrder.add(order);
                }
                return changed ? new OrderBy(orderBy.source(), orderBy.child(), newOrder) : orderBy;
            }
            if (plan instanceof Aggregate) {
                Aggregate agg = (Aggregate)plan;
                if (!Resolvables.resolved((Iterable)agg.aggregates())) {
                    return agg;
                }
                boolean changed = false;
                ArrayList<Object> newGroupings = new ArrayList<Object>(agg.groupings().size());
                List aggregates = agg.aggregates();
                int max = aggregates.size();
                for (Expression exp : agg.groupings()) {
                    Integer ordinal = ResolveOrdinalInOrderByAndGroupBy.findOrdinal(exp);
                    if (ordinal != null) {
                        changed = true;
                        String errorMessage = null;
                        if (ordinal > 0 && ordinal <= max) {
                            NamedExpression reference = (NamedExpression)aggregates.get(ordinal - 1);
                            if (Analyzer.containsAggregate((Expression)reference)) {
                                errorMessage = LoggerMessageFormat.format((String)"Ordinal [{}] in [{}] refers to an invalid argument, aggregate function [{}]", (Object[])new Object[]{ordinal, agg.sourceText(), reference.sourceText()});
                            } else {
                                newGroupings.add(reference);
                            }
                        } else {
                            errorMessage = LoggerMessageFormat.format((String)"Invalid ordinal [{}] specified in [{}] (valid range is [1, {}])", (Object[])new Object[]{ordinal, agg.sourceText(), max});
                        }
                        if (errorMessage == null) continue;
                        newGroupings.add(new UnresolvedAttribute(exp.source(), agg.sourceText(), null, errorMessage));
                        continue;
                    }
                    newGroupings.add(exp);
                }
                return changed ? new Aggregate(agg.source(), agg.child(), newGroupings, aggregates) : agg;
            }
            return plan;
        }

        private static Integer findOrdinal(Expression expression) {
            Object v;
            if (expression.foldable() && expression.dataType().isInteger() && (v = Foldables.valueOf((Expression)expression)) instanceof Number) {
                return ((Number)v).intValue();
            }
            return null;
        }
    }

    private static class ResolveMissingRefs
    extends AnalyzerRules.BaseAnalyzerRule {
        private ResolveMissingRefs() {
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            LogicalPlan child;
            if (plan instanceof OrderBy) {
                AttributeSet resolvedRefs;
                AttributeSet missing;
                OrderBy o = (OrderBy)plan;
                child = o.child();
                ArrayList<Order> maybeResolved = new ArrayList<Order>();
                for (Order or : o.order()) {
                    maybeResolved.add(or.resolved() ? or : ResolveMissingRefs.tryResolveExpression(or, child));
                }
                Stream<Order> referencesStream = maybeResolved.stream().filter(Expression::resolved);
                if (Expressions.hasReferenceAttribute((Collection)child.outputSet())) {
                    AttributeMap.Builder builder = AttributeMap.builder();
                    child.forEachUp(p -> p.forEachExpressionUp(Alias.class, a -> builder.put(a.toAttribute(), (Object)a.child())));
                    AttributeMap collectRefs = builder.build();
                    referencesStream = referencesStream.filter(r -> {
                        for (Attribute attr : child.outputSet()) {
                            Expression source;
                            if (!(attr instanceof ReferenceAttribute) || !(source = (Expression)collectRefs.resolve((Object)attr, (Object)attr)).equals((Object)r.child())) continue;
                            return false;
                        }
                        return true;
                    });
                }
                if (!(missing = (resolvedRefs = Expressions.references(referencesStream.collect(Collectors.toList()))).subtract(child.outputSet())).isEmpty()) {
                    ArrayList<Attribute> failedAttrs = new ArrayList<Attribute>();
                    LogicalPlan newChild = ResolveMissingRefs.propagateMissing(o.child(), missing, failedAttrs);
                    if (!failedAttrs.isEmpty()) {
                        ArrayList<Order> newOrders = new ArrayList<Order>();
                        for (Order order : o.order()) {
                            Order transformed;
                            newOrders.add(order.equals((Object)(transformed = (Order)order.transformUp(UnresolvedAttribute.class, ua -> ResolveMissingRefs.resolveMetadataToMessage(ua, failedAttrs, "order")))) ? order : transformed);
                        }
                        return o.order().equals(newOrders) ? o : new OrderBy(o.source(), o.child(), newOrders);
                    }
                    return new Project(o.source(), (LogicalPlan)new OrderBy(o.source(), newChild, maybeResolved), o.child().output());
                }
                if (!maybeResolved.equals(o.order())) {
                    return new OrderBy(o.source(), o.child(), maybeResolved);
                }
            }
            if (plan instanceof Filter) {
                Filter f = (Filter)plan;
                Expression maybeResolved = ResolveMissingRefs.tryResolveExpression(f.condition(), f.child());
                AttributeSet resolvedRefs = new AttributeSet((Collection)maybeResolved.references().stream().filter(Expression::resolved).collect(Collectors.toList()));
                AttributeSet missing = resolvedRefs.subtract(f.child().outputSet());
                if (!missing.isEmpty()) {
                    ArrayList<Attribute> failedAttrs = new ArrayList<Attribute>();
                    LogicalPlan newChild = ResolveMissingRefs.propagateMissing(f.child(), missing, failedAttrs);
                    if (!failedAttrs.isEmpty()) {
                        Expression transformed = (Expression)f.condition().transformUp(UnresolvedAttribute.class, ua -> ResolveMissingRefs.resolveMetadataToMessage(ua, failedAttrs, "filter"));
                        return f.condition().equals((Object)transformed) ? f : f.with(transformed);
                    }
                    return new Project(f.source(), (LogicalPlan)f.with(newChild, maybeResolved), f.child().output());
                }
                if (!maybeResolved.equals((Object)f.condition())) {
                    return f.with(maybeResolved);
                }
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                child = a.child();
                ArrayList newGroupings = new ArrayList(a.groupings().size());
                a.groupings().forEach(e -> newGroupings.add(ResolveMissingRefs.tryResolveExpression(e, child)));
                ArrayList newAggregates = new ArrayList(a.aggregates().size());
                a.aggregates().forEach(e -> newAggregates.add(ResolveMissingRefs.tryResolveExpression(e, child)));
                if (!newAggregates.equals(a.aggregates()) || !newGroupings.equals(a.groupings())) {
                    return new Aggregate(a.source(), child, newGroupings, newAggregates);
                }
            }
            return plan;
        }

        static <E extends Expression> E tryResolveExpression(E exp, LogicalPlan plan) {
            E resolved = Analyzer.resolveExpression(exp, plan);
            if (!resolved.resolved() && plan.children().size() == 1 && !(plan instanceof SubQueryAlias)) {
                return ResolveMissingRefs.tryResolveExpression(resolved, (LogicalPlan)plan.children().get(0));
            }
            return resolved;
        }

        private static LogicalPlan propagateMissing(LogicalPlan plan, AttributeSet missing, List<Attribute> failed) {
            if (missing.isEmpty()) {
                return plan;
            }
            if (plan instanceof Project) {
                Project p = (Project)plan;
                AttributeSet diff = missing.subtract(p.child().outputSet());
                return new Project(p.source(), ResolveMissingRefs.propagateMissing(p.child(), diff, failed), CollectionUtils.combine((Collection[])new Collection[]{p.projections(), missing}));
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                for (Attribute m : missing) {
                    if (Expressions.match((List)a.groupings(), arg_0 -> ((Attribute)m).semanticEquals(arg_0))) continue;
                    m = new UnresolvedAttribute(m.source(), m.name(), m.qualifier(), null, null, (Object)new AggGroupingFailure(Expressions.names((Collection)a.groupings())));
                    failed.add(m);
                }
                if (!failed.isEmpty()) {
                    return plan;
                }
                return new Aggregate(a.source(), a.child(), a.groupings(), CollectionUtils.combine((Collection[])new Collection[]{a.aggregates(), missing}));
            }
            if (plan instanceof UnaryPlan) {
                UnaryPlan unary = (UnaryPlan)plan;
                return unary.replaceChild(ResolveMissingRefs.propagateMissing(unary.child(), missing, failed));
            }
            failed.addAll((Collection<Attribute>)missing);
            return plan;
        }

        private static UnresolvedAttribute resolveMetadataToMessage(UnresolvedAttribute ua, List<Attribute> attrs, String actionName) {
            for (Attribute attr : attrs) {
                UnresolvedAttribute fua;
                Object metadata;
                if (ua.resolutionMetadata() != null || !attr.name().equals(ua.name()) || !(attr instanceof UnresolvedAttribute) || !((metadata = (fua = (UnresolvedAttribute)attr).resolutionMetadata()) instanceof AggGroupingFailure)) continue;
                List<String> names = ((AggGroupingFailure)metadata).expectedGrouping;
                return ua.withUnresolvedMessage("Cannot " + actionName + " by non-grouped column [" + ua.qualifiedName() + "], expected " + names);
            }
            return ua;
        }

        private static class AggGroupingFailure {
            final List<String> expectedGrouping;

            private AggGroupingFailure(List<String> expectedGrouping) {
                this.expectedGrouping = expectedGrouping;
            }
        }
    }

    private static class ResolveFilterRefs
    extends AnalyzerRules.AnalyzerRule<LogicalPlan> {
        private ResolveFilterRefs() {
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            Aggregate a;
            Expression newCondition;
            Filter f;
            LogicalPlan condition;
            Project p;
            LogicalPlan logicalPlan;
            if (plan instanceof Project && (logicalPlan = (p = (Project)plan).child()) instanceof Filter && !(condition = (f = (Filter)logicalPlan).condition()).resolved() && f.childrenResolved() && (newCondition = ResolveFilterRefs.replaceAliases((Expression)condition, p.projections())) != condition) {
                return new Project(p.source(), (LogicalPlan)f.with(newCondition), p.projections());
            }
            if (plan instanceof Aggregate && (condition = (a = (Aggregate)plan).child()) instanceof Filter && !(condition = (f = (Filter)condition).condition()).resolved() && f.childrenResolved() && (newCondition = ResolveFilterRefs.replaceAliases((Expression)condition, a.aggregates())) != condition) {
                return new Aggregate(a.source(), (LogicalPlan)f.with(newCondition), a.groupings(), a.aggregates());
            }
            return plan;
        }

        private static Expression replaceAliases(Expression condition, List<? extends NamedExpression> named) {
            ArrayList aliases = new ArrayList();
            named.forEach(n -> {
                if (n instanceof Alias) {
                    aliases.add((Alias)n);
                }
            });
            return (Expression)condition.transformUp(UnresolvedAttribute.class, u -> {
                boolean qualified = u.qualifier() != null;
                for (Alias alias : aliases) {
                    if (alias.anyMatch(e -> e == u) || !(qualified ? Objects.equals(alias.qualifiedName(), u.qualifiedName()) : Objects.equals(alias.name(), u.name()))) continue;
                    return alias;
                }
                return u;
            });
        }
    }

    private static class ResolveFunctions
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private ResolveFunctions() {
        }

        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)plan.transformExpressionsUp(UnresolvedFunction.class, uf -> {
                if (uf.analyzed()) {
                    return uf;
                }
                if (Analyzer.hasStar(uf.arguments())) {
                    FunctionResolutionStrategy strategy = uf.resolutionStrategy();
                    if (SqlFunctionResolution.DISTINCT == strategy) {
                        uf = uf.withMessage("* is not valid with DISTINCT");
                    } else if (SqlFunctionResolution.EXTRACT == strategy) {
                        uf = uf.withMessage("Can't extract from *");
                    } else if (uf.name().toUpperCase(Locale.ROOT).equals("COUNT")) {
                        uf = new UnresolvedFunction(uf.source(), uf.name(), strategy, Collections.singletonList(new Literal(((Expression)uf.arguments().get(0)).source(), (Object)1, DataTypes.INTEGER)));
                    }
                    if (uf.analyzed()) {
                        return uf;
                    }
                }
                return AnalyzerRules.resolveFunction((UnresolvedFunction)uf, (Configuration)context.configuration(), (FunctionRegistry)context.functionRegistry());
            });
        }
    }

    private static class ResolveAliases
    extends AnalyzerRules.BaseAnalyzerRule {
        private ResolveAliases() {
        }

        protected LogicalPlan doRule(LogicalPlan plan) {
            if (plan instanceof Project) {
                Project p = (Project)plan;
                if (ResolveAliases.hasUnresolvedAliases(p.projections())) {
                    return new Project(p.source(), p.child(), ResolveAliases.assignAliases(p.projections()));
                }
                return p;
            }
            if (plan instanceof Aggregate) {
                Aggregate a = (Aggregate)plan;
                if (ResolveAliases.hasUnresolvedAliases(a.aggregates())) {
                    return new Aggregate(a.source(), a.child(), a.groupings(), ResolveAliases.assignAliases(a.aggregates()));
                }
                return a;
            }
            if (plan instanceof Pivot) {
                Pivot p = (Pivot)plan;
                if (ResolveAliases.hasUnresolvedAliases(p.values())) {
                    p = new Pivot(p.source(), p.child(), p.column(), ResolveAliases.assignAliases(p.values()), p.aggregates());
                }
                if (ResolveAliases.hasUnresolvedAliases(p.aggregates())) {
                    p = new Pivot(p.source(), p.child(), p.column(), p.values(), ResolveAliases.assignAliases(p.aggregates()));
                }
                return p;
            }
            return plan;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean hasUnresolvedAliases(List<? extends NamedExpression> expressions) {
            if (expressions == null) return false;
            if (!Expressions.anyMatch(expressions, UnresolvedAlias.class::isInstance)) return false;
            return true;
        }

        private static List<NamedExpression> assignAliases(List<? extends NamedExpression> exprs) {
            ArrayList<NamedExpression> newExpr = new ArrayList<NamedExpression>(exprs.size());
            for (NamedExpression namedExpression : exprs) {
                NamedExpression transformed;
                newExpr.add(namedExpression.equals((Object)(transformed = (NamedExpression)namedExpression.transformUp(UnresolvedAlias.class, ua -> {
                    Cast c;
                    Expression child = ua.child();
                    if (child instanceof NamedExpression) {
                        return child;
                    }
                    if (!child.resolved()) {
                        return ua;
                    }
                    if (child instanceof Cast && (c = (Cast)child).field() instanceof NamedExpression) {
                        return new Alias(c.source(), ((NamedExpression)c.field()).name(), (Expression)c);
                    }
                    return new Alias(child.source(), child.sourceText(), child);
                }))) ? namedExpression : transformed);
            }
            return newExpr;
        }
    }

    private static class ProjectedAggregations
    extends AnalyzerRules.AnalyzerRule<Project> {
        private ProjectedAggregations() {
        }

        protected LogicalPlan rule(Project p) {
            if (Analyzer.containsAggregate(p.projections())) {
                return new Aggregate(p.source(), p.child(), Collections.emptyList(), p.projections());
            }
            return p;
        }
    }

    private static class HavingOverProject
    extends AnalyzerRules.AnalyzerRule<Filter> {
        private HavingOverProject() {
        }

        protected LogicalPlan rule(Filter f) {
            LogicalPlan logicalPlan = f.child();
            if (logicalPlan instanceof Project) {
                Project p = (Project)logicalPlan;
                for (Expression n : p.projections()) {
                    if ((n = Alias.unwrap((Expression)n)).foldable() || Functions.isAggregate((Expression)n)) continue;
                    if (!n.anyMatch(FieldAttribute.class::isInstance)) continue;
                    return f;
                }
                if (Analyzer.containsAggregate(f.condition())) {
                    return f.with((LogicalPlan)new Aggregate(p.source(), p.child(), Collections.emptyList(), p.projections()), f.condition());
                }
            }
            return f;
        }

        protected boolean skipResolved() {
            return false;
        }
    }

    private static class ResolveAggsInHaving
    extends AnalyzerRules.ParameterizedAnalyzerRule<Filter, AnalyzerContext> {
        private ResolveAggsInHaving() {
        }

        protected boolean skipResolved() {
            return false;
        }

        protected LogicalPlan rule(Filter f, AnalyzerContext context) {
            Aggregate agg;
            LogicalPlan logicalPlan = f.child();
            if (logicalPlan instanceof Aggregate && (agg = (Aggregate)logicalPlan).resolved()) {
                Set<NamedExpression> missing = null;
                Expression condition = f.condition();
                if (!condition.resolved()) {
                    Aggregate tryResolvingCondition = new Aggregate(agg.source(), agg.child(), agg.groupings(), CollectionUtils.combine((Collection)agg.aggregates(), (Object[])new NamedExpression[]{new Alias(f.source(), ".having", condition)}));
                    Function analyze = (Function)context.analyzeWithoutVerify().get();
                    tryResolvingCondition = (Aggregate)analyze.apply(tryResolvingCondition);
                    if (tryResolvingCondition.resolved()) {
                        condition = ((Alias)tryResolvingCondition.aggregates().get(tryResolvingCondition.aggregates().size() - 1)).child();
                    } else {
                        return f;
                    }
                }
                if (!(missing = ResolveAggsInHaving.findMissingAggregate(agg, condition)).isEmpty()) {
                    Aggregate newAgg = new Aggregate(agg.source(), agg.child(), agg.groupings(), CollectionUtils.combine((Collection[])new Collection[]{agg.aggregates(), missing}));
                    Filter newFilter = f.with((LogicalPlan)newAgg, condition);
                    return new Project(f.source(), (LogicalPlan)newFilter, f.output());
                }
                return f.with(condition);
            }
            return f;
        }

        private static Set<NamedExpression> findMissingAggregate(Aggregate target, Expression from) {
            LinkedHashSet<NamedExpression> missing = new LinkedHashSet<NamedExpression>();
            for (Expression filterAgg : from.collect(Functions::isAggregate)) {
                if (Expressions.anyMatch((List)target.aggregates(), a -> Alias.unwrap((Expression)a).equals((Object)filterAgg))) continue;
                missing.add(Expressions.wrapAsNamed((Expression)filterAgg));
            }
            return missing;
        }
    }

    private static class ResolveAggsInOrderBy
    extends AnalyzerRules.AnalyzerRule<OrderBy> {
        private ResolveAggsInOrderBy() {
        }

        protected boolean skipResolved() {
            return false;
        }

        protected LogicalPlan rule(OrderBy ob) {
            List orders = ob.order();
            ArrayList<Expression> aggs = new ArrayList<Expression>();
            for (Order order : orders) {
                if (!Functions.isAggregate((Expression)order.child())) continue;
                aggs.add(order.child());
            }
            if (aggs.isEmpty()) {
                return ob;
            }
            Holder found = new Holder((Object)Boolean.FALSE);
            LogicalPlan plan = (LogicalPlan)ob.transformDown(Aggregate.class, a -> {
                if (found.get() == Boolean.FALSE) {
                    found.set((Object)Boolean.TRUE);
                    ArrayList<NamedExpression> missing = new ArrayList<NamedExpression>();
                    for (Expression orderedAgg : aggs) {
                        if (Expressions.anyMatch((List)a.aggregates(), e -> Alias.unwrap((Expression)e).equals((Object)orderedAgg))) continue;
                        missing.add(Expressions.wrapAsNamed((Expression)orderedAgg));
                    }
                    if (!missing.isEmpty()) {
                        return new Aggregate(a.source(), a.child(), a.groupings(), CollectionUtils.combine((List)a.aggregates(), missing));
                    }
                }
                return a;
            });
            if (plan != ob) {
                return new Project(ob.source(), plan, ob.output());
            }
            return ob;
        }
    }

    public static class ReplaceSubQueryAliases
    extends AnalyzerRules.AnalyzerRule<UnaryPlan> {
        protected LogicalPlan rule(UnaryPlan plan) {
            LogicalPlan logicalPlan = plan.child();
            if (logicalPlan instanceof SubQueryAlias) {
                SubQueryAlias a = (SubQueryAlias)logicalPlan;
                return (LogicalPlan)plan.transformExpressionsDown(FieldAttribute.class, f -> {
                    List children;
                    if (f.qualifier() != null && f.qualifier().equals(a.alias()) && !(children = a.collectFirstChildren(p -> p instanceof EsRelation)).isEmpty()) {
                        return f.withQualifier(((EsRelation)children.get(0)).index().name());
                    }
                    return f;
                });
            }
            return plan;
        }

        protected boolean skipResolved() {
            return false;
        }
    }

    public static class PruneSubQueryAliases
    extends AnalyzerRules.AnalyzerRule<SubQueryAlias> {
        protected LogicalPlan rule(SubQueryAlias alias) {
            return alias.child();
        }

        protected boolean skipResolved() {
            return false;
        }
    }

    public static class CleanAliases
    extends AnalyzerRules.AnalyzerRule<LogicalPlan> {
        public static final CleanAliases INSTANCE = new CleanAliases();

        protected LogicalPlan rule(LogicalPlan plan) {
            if (plan instanceof Project) {
                Project p = (Project)plan;
                return new Project(p.source(), p.child(), CleanAliases.cleanChildrenAliases(p.projections()));
            }
            if (plan instanceof Aggregate) {
                Aggregate a2 = (Aggregate)plan;
                return new Aggregate(a2.source(), a2.child(), CleanAliases.cleanAllAliases(a2.groupings()), CleanAliases.cleanChildrenAliases(a2.aggregates()));
            }
            if (plan instanceof Pivot) {
                Pivot p = (Pivot)plan;
                return new Pivot(p.source(), p.child(), CleanAliases.trimAliases(p.column()), CleanAliases.cleanChildrenAliases(p.values()), CleanAliases.cleanChildrenAliases(p.aggregates()));
            }
            return (LogicalPlan)plan.transformExpressionsOnly(Alias.class, a -> a.child());
        }

        private static List<NamedExpression> cleanChildrenAliases(List<? extends NamedExpression> args) {
            ArrayList<NamedExpression> cleaned = new ArrayList<NamedExpression>(args.size());
            for (NamedExpression namedExpression : args) {
                cleaned.add((NamedExpression)CleanAliases.trimNonTopLevelAliases((Expression)namedExpression));
            }
            return cleaned;
        }

        private static List<Expression> cleanAllAliases(List<Expression> args) {
            ArrayList<Expression> cleaned = new ArrayList<Expression>(args.size());
            for (Expression e : args) {
                cleaned.add(CleanAliases.trimAliases(e));
            }
            return cleaned;
        }

        public static Expression trimNonTopLevelAliases(Expression e) {
            if (e instanceof Alias) {
                Alias a = (Alias)e;
                return new Alias(a.source(), a.name(), a.qualifier(), CleanAliases.trimAliases(a.child()), a.id());
            }
            return CleanAliases.trimAliases(e);
        }

        private static Expression trimAliases(Expression e) {
            return (Expression)e.transformDown(Alias.class, Alias::child);
        }

        protected boolean skipResolved() {
            return false;
        }
    }
}

