/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.sql.SqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.sql.plugin.SqlStatsAction;
import org.elasticsearch.xpack.sql.plugin.SqlStatsRequest;
import org.elasticsearch.xpack.sql.plugin.SqlStatsResponse;

public class SqlUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public SqlUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(XPackUsageFeatureAction.SQL.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
        this.client = client;
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        SqlStatsRequest sqlRequest = new SqlStatsRequest();
        sqlRequest.includeStats(true);
        sqlRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute((ActionType)SqlStatsAction.INSTANCE, (ActionRequest)sqlRequest, listener.delegateFailureAndWrap((l, r) -> {
            List countersPerNode = r.getNodes().stream().map(SqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
            Counters mergedCounters = Counters.merge(countersPerNode);
            SqlFeatureSetUsage usage = new SqlFeatureSetUsage(mergedCounters.toNestedMap());
            l.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureSet.Usage)usage));
        }));
    }
}

