/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.xpack.core.security.action.UpdateIndexMigrationVersionAction;
import org.elasticsearch.xpack.core.security.support.SecurityMigrationTaskParams;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;
import org.elasticsearch.xpack.security.support.SecurityMigrations;

public class SecurityMigrationExecutor
extends PersistentTasksExecutor<SecurityMigrationTaskParams> {
    private static final Logger logger = LogManager.getLogger(SecurityMigrationExecutor.class);
    private final SecurityIndexManager securityIndexManager;
    private final Client client;
    private final TreeMap<Integer, SecurityMigrations.SecurityMigration> migrationByVersion;

    public SecurityMigrationExecutor(String taskName, Executor executor, SecurityIndexManager securityIndexManager, Client client, TreeMap<Integer, SecurityMigrations.SecurityMigration> migrationByVersion) {
        super(taskName, executor);
        this.securityIndexManager = securityIndexManager;
        this.client = client;
        this.migrationByVersion = migrationByVersion;
    }

    protected void nodeOperation(AllocatedPersistentTask task, SecurityMigrationTaskParams params, PersistentTaskState state) {
        ActionListener listener = ActionListener.wrap(res -> task.markAsCompleted(), exception -> {
            logger.warn("Security migration failed: " + exception);
            task.markAsFailed(exception);
        });
        if (!params.isMigrationNeeded()) {
            this.updateMigrationVersion(params.getMigrationVersion(), this.securityIndexManager.getConcreteIndexName(), (ActionListener<Void>)ActionListener.wrap(response -> {
                logger.info("Security migration not needed. Setting current version to: [" + params.getMigrationVersion() + "]");
                listener.onResponse(response);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            return;
        }
        this.applyOutstandingMigrations(task, params.getMigrationVersion(), (ActionListener<Void>)listener);
    }

    private void applyOutstandingMigrations(AllocatedPersistentTask task, int currentMigrationVersion, ActionListener<Void> listener) {
        if (task.isCancelled()) {
            listener.onFailure((Exception)new TaskCancelledException("Security migration task cancelled"));
            return;
        }
        Map.Entry<Integer, SecurityMigrations.SecurityMigration> migrationEntry = this.migrationByVersion.higherEntry(currentMigrationVersion);
        if (migrationEntry != null && this.securityIndexManager.isReadyForSecurityMigration(migrationEntry.getValue())) {
            migrationEntry.getValue().migrate(this.securityIndexManager, this.client, (ActionListener<Void>)ActionListener.wrap(response -> this.updateMigrationVersion((Integer)migrationEntry.getKey(), this.securityIndexManager.getConcreteIndexName(), (ActionListener<Void>)new ThreadedActionListener(this.getExecutor(), ActionListener.wrap(updateResponse -> this.applyOutstandingMigrations(task, (Integer)migrationEntry.getKey(), listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0)))), arg_0 -> listener.onFailure(arg_0)));
        } else {
            logger.info("Security migrations applied until version: [" + currentMigrationVersion + "]");
            listener.onResponse(null);
        }
    }

    private void updateMigrationVersion(int migrationVersion, String indexName, ActionListener<Void> listener) {
        this.client.execute((ActionType)UpdateIndexMigrationVersionAction.INSTANCE, (ActionRequest)new UpdateIndexMigrationVersionAction.Request(TimeValue.MAX_VALUE, migrationVersion, indexName), ActionListener.wrap(response -> listener.onResponse(null), arg_0 -> listener.onFailure(arg_0)));
    }
}

