/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.DnRoleMapperSettings;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.PrivilegedFileWatcher;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.support.mapper.AbstractRoleMapperClearRealmCache;

public class DnRoleMapper
extends AbstractRoleMapperClearRealmCache {
    private static final Logger logger = LogManager.getLogger(DnRoleMapper.class);
    protected final RealmConfig config;
    private final Path file;
    private final boolean useUnmappedGroupsAsRoles;
    private volatile Map<String, List<String>> dnRoles;

    public DnRoleMapper(RealmConfig config, ResourceWatcherService watcherService) {
        this.config = config;
        this.useUnmappedGroupsAsRoles = (Boolean)config.getSetting(DnRoleMapperSettings.USE_UNMAPPED_GROUPS_AS_ROLES_SETTING);
        this.file = DnRoleMapper.resolveFile(config);
        this.dnRoles = AccessController.doPrivileged(() -> DnRoleMapper.parseFileLenient(this.file, logger, config.type(), config.name()));
        PrivilegedFileWatcher watcher = new PrivilegedFileWatcher(this.file.getParent());
        watcher.addListener(new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start file watcher for role mapping file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
    }

    public static Path resolveFile(RealmConfig realmConfig) {
        String location = (String)realmConfig.getSetting(DnRoleMapperSettings.ROLE_MAPPING_FILE_SETTING);
        return Security.resolveSecuredConfigFile(realmConfig.env(), location);
    }

    public static Map<String, List<String>> parseFileLenient(Path path, Logger logger, String realmType, String realmName) {
        try {
            return DnRoleMapper.parseFile(path, logger, realmType, realmName, false);
        }
        catch (Exception e) {
            logger.error(() -> Strings.format((String)"failed to parse role mappings file [%s]. skipping/removing all mappings...", (Object[])new Object[]{path.toAbsolutePath()}), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, List<String>> parseFile(Path path, Logger logger, String realmType, String realmName, boolean strict) {
        logger.trace("reading realm [{}/{}] role mappings file [{}]...", (Object)realmType, (Object)realmName, (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            String message = Strings.format((String)"Role mapping file [%s] for realm [%s] does not exist.", (Object[])new Object[]{path.toAbsolutePath(), realmName});
            if (strict) {
                throw new ElasticsearchException(message, new Object[0]);
            }
            logger.warn(message + " Role mapping will be skipped.");
            return Collections.emptyMap();
        }
        try {
            InputStream file = Files.newInputStream(path, new OpenOption[0]);
            Settings settings = Settings.builder().loadFromStream(path.getFileName().toString(), file, false).build();
            HashMap<DN, HashSet<String>> dnToRoles = new HashMap<DN, HashSet<String>>();
            Set roles = settings.names();
            for (String role : roles) {
                for (String providedDn : settings.getAsList(role)) {
                    try {
                        DN dn = new DN(providedDn);
                        HashSet<String> dnRoles = (HashSet<String>)dnToRoles.get(dn);
                        if (dnRoles == null) {
                            dnRoles = new HashSet<String>();
                            dnToRoles.put(dn, dnRoles);
                        }
                        dnRoles.add(role);
                    }
                    catch (LDAPException e) {
                        String message = Strings.format((String)"invalid DN [%s] found in [%s] role mappings [%s] for realm [%s/%s].", (Object[])new Object[]{providedDn, realmType, path.toAbsolutePath(), realmType, realmName});
                        if (strict) {
                            throw new ElasticsearchException(message, (Throwable)e, new Object[0]);
                        }
                        logger.error(message + " skipping...", (Throwable)e);
                    }
                }
            }
            logger.debug("[{}] role mappings found in file [{}] for realm [{}/{}]", (Object)dnToRoles.size(), (Object)path.toAbsolutePath(), (Object)realmType, (Object)realmName);
            Map<String, List> normalizedMap = dnToRoles.entrySet().stream().collect(Collectors.toMap(entry -> ((DN)entry.getKey()).toNormalizedString(), entry -> List.copyOf((Collection)entry.getValue())));
            return Collections.unmodifiableMap(normalizedMap);
        }
        catch (IOException | SettingsException e) {
            throw new ElasticsearchException("could not read realm [" + realmType + "/" + realmName + "] role mappings file [" + path.toAbsolutePath() + "]", e, new Object[0]);
        }
    }

    int mappingsCount() {
        return this.dnRoles.size();
    }

    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        try {
            listener.onResponse(this.resolveRoles(user.getDn(), user.getGroups()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public Set<String> resolveRoles(String userDnString, Collection<String> groupDns) {
        String normalizedUserDn;
        List<String> rolesMappedToUserDn;
        HashSet<String> roles = new HashSet<String>();
        for (String groupDnString : groupDns) {
            DN groupDn = LdapUtils.dn(groupDnString);
            String normalizedGroupDn = groupDn.toNormalizedString();
            if (this.dnRoles.containsKey(normalizedGroupDn)) {
                roles.addAll((Collection<String>)this.dnRoles.get(normalizedGroupDn));
                continue;
            }
            if (!this.useUnmappedGroupsAsRoles) continue;
            roles.add(LdapUtils.relativeName(groupDn));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("the roles [{}], are mapped from these [{}] groups [{}] using file [{}] for realm [{}/{}]", roles, (Object)this.config.type(), groupDns, (Object)this.file.getFileName(), (Object)this.config.type(), (Object)this.config.name());
        }
        if ((rolesMappedToUserDn = this.dnRoles.get(normalizedUserDn = LdapUtils.dn(userDnString).toNormalizedString())) != null) {
            roles.addAll(rolesMappedToUserDn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("the roles [{}], are mapped from the user [{}] using file [{}] for realm [{}/{}]", rolesMappedToUserDn == null ? Collections.emptySet() : rolesMappedToUserDn, (Object)normalizedUserDn, (Object)this.file.getFileName(), (Object)this.config.type(), (Object)this.config.name());
        }
        return roles;
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(DnRoleMapper.this.file)) {
                Map<String, List<String>> previousDnRoles = DnRoleMapper.this.dnRoles;
                DnRoleMapper.this.dnRoles = AccessController.doPrivileged(() -> DnRoleMapper.parseFileLenient(file, logger, DnRoleMapper.this.config.type(), DnRoleMapper.this.config.name()));
                if (!previousDnRoles.equals(DnRoleMapper.this.dnRoles)) {
                    logger.info("role mappings file [{}] changed for realm [{}/{}]. updating mappings...", (Object)file.toAbsolutePath(), (Object)DnRoleMapper.this.config.type(), (Object)DnRoleMapper.this.config.name());
                    DnRoleMapper.this.clearRealmCachesOnLocalNode();
                }
            }
        }
    }
}

