/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.ClaimSetting;
import org.elasticsearch.xpack.security.authc.jwt.FallbackableClaim;

public final class ClaimParser {
    private final String setting;
    private final String claimName;
    private final String regexPattern;
    private final Function<JWTClaimsSet, List<String>> parser;

    public ClaimParser(String setting, String claimName, String regexPattern, Function<JWTClaimsSet, List<String>> parser) {
        this.setting = setting;
        this.claimName = claimName;
        this.regexPattern = regexPattern;
        this.parser = parser;
    }

    public String getSetting() {
        return this.setting;
    }

    public String getClaimName() {
        return this.claimName;
    }

    public String getRegexPattern() {
        return this.regexPattern;
    }

    public Function<JWTClaimsSet, List<String>> getParser() {
        return this.parser;
    }

    public List<String> getClaimValues(JWTClaimsSet claims) {
        return this.parser.apply(claims);
    }

    public String getClaimValue(JWTClaimsSet claims) {
        List<String> claimValues = this.parser.apply(claims);
        if (claimValues == null || claimValues.isEmpty()) {
            return null;
        }
        return claimValues.get(0);
    }

    public String toString() {
        if (this.claimName == null) {
            return "No claim for [" + this.setting + "]";
        }
        if (this.regexPattern == null) {
            return "Claim [" + this.claimName + "] for [" + this.setting + "]";
        }
        return "Claim [" + this.claimName + "] with pattern [" + this.regexPattern + "] for [" + this.setting + "]";
    }

    private static Collection<String> parseClaimValues(JWTClaimsSet claimsSet, FallbackableClaim fallbackableClaim, String settingKey) {
        Collection<String> values;
        Object claimValueObject = claimsSet.getClaim(fallbackableClaim.getActualName());
        if (claimValueObject == null) {
            values = List.of();
        } else if (claimValueObject instanceof String) {
            values = List.of((String)claimValueObject);
        } else if (claimValueObject instanceof Collection && ((Collection)claimValueObject).stream().allMatch(c -> c instanceof String)) {
            values = (Collection)claimValueObject;
        } else {
            throw new SettingsException("Setting [ " + settingKey + "] expects claim [" + fallbackableClaim + "] with String or a String Array value");
        }
        return values;
    }

    public static ClaimParser forSetting(Logger logger, ClaimSetting setting, RealmConfig realmConfig, boolean required) {
        return ClaimParser.forSetting(logger, setting, Map.of(), realmConfig, required);
    }

    public static ClaimParser forSetting(Logger logger, ClaimSetting setting, Map<String, String> fallbackClaimNames, RealmConfig realmConfig, boolean required) {
        if (realmConfig.hasSetting(setting.getClaim())) {
            String claimName = (String)realmConfig.getSetting(setting.getClaim());
            if (realmConfig.hasSetting(setting.getPattern())) {
                Pattern regex = Pattern.compile((String)realmConfig.getSetting(setting.getPattern()));
                return new ClaimParser(setting.name(realmConfig), claimName, regex.pattern(), claims -> {
                    FallbackableClaim fallbackableClaim = new FallbackableClaim(claimName, fallbackClaimNames, (JWTClaimsSet)claims);
                    Collection<String> values = ClaimParser.parseClaimValues(claims, fallbackableClaim, RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()));
                    return values.stream().map(s -> {
                        if (s == null) {
                            logger.debug("Claim [{}] is null", (Object)fallbackableClaim);
                            return null;
                        }
                        Matcher matcher = regex.matcher((CharSequence)s);
                        if (!matcher.find()) {
                            logger.debug("Claim [{}] is [{}], which does not match [{}]", (Object)fallbackableClaim, s, (Object)regex.pattern());
                            return null;
                        }
                        String value = matcher.group(1);
                        if (Strings.isNullOrEmpty((String)value)) {
                            logger.debug("Claim [{}] is [{}], which does match [{}] but group(1) is empty", (Object)fallbackableClaim, s, (Object)regex.pattern());
                            return null;
                        }
                        return value;
                    }).filter(Objects::nonNull).toList();
                });
            }
            return new ClaimParser(setting.name(realmConfig), claimName, null, claims -> {
                FallbackableClaim fallbackableClaim = new FallbackableClaim(claimName, fallbackClaimNames, (JWTClaimsSet)claims);
                return ClaimParser.parseClaimValues(claims, fallbackableClaim, RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim())).stream().filter(Objects::nonNull).toList();
            });
        }
        if (required) {
            throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()) + "] is required");
        }
        if (realmConfig.hasSetting(setting.getPattern())) {
            throw new SettingsException("Setting [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getPattern()) + "] cannot be set unless [" + RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)setting.getClaim()) + "] is also set");
        }
        return new ClaimParser(setting.name(realmConfig), null, null, attributes -> List.of());
    }
}

