/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.Aggregator;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class AggregationOperator
implements Operator {
    private boolean finished;
    private Page output;
    private final List<Aggregator> aggregators;
    private final DriverContext driverContext;
    private long aggregationNanos;
    private long aggregationFinishNanos;
    private int pagesProcessed;

    public AggregationOperator(List<Aggregator> aggregators, DriverContext driverContext) {
        Objects.requireNonNull(aggregators);
        AggregationOperator.checkNonEmpty(aggregators);
        this.aggregators = aggregators;
        this.driverContext = driverContext;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInput(Page page) {
        long start = System.nanoTime();
        AggregationOperator.checkState(this.needsInput(), "Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        try (BooleanVector noMasking = this.driverContext.blockFactory().newConstantBooleanVector(true, page.getPositionCount());){
            for (Aggregator aggregator : this.aggregators) {
                aggregator.processPage(page, noMasking);
            }
        }
        finally {
            page.releaseBlocks();
            this.aggregationNanos += System.nanoTime() - start;
            ++this.pagesProcessed;
        }
    }

    @Override
    public Page getOutput() {
        Page p = this.output;
        this.output = null;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        long start;
        block5: {
            if (this.finished) {
                return;
            }
            start = System.nanoTime();
            this.finished = true;
            Releasable[] blocks = null;
            boolean success = false;
            try {
                int[] aggBlockCounts = this.aggregators.stream().mapToInt(Aggregator::evaluateBlockCount).toArray();
                blocks = new Block[Arrays.stream(aggBlockCounts).sum()];
                int offset = 0;
                for (int i = 0; i < this.aggregators.size(); ++i) {
                    Aggregator aggregator = this.aggregators.get(i);
                    aggregator.evaluate((Block[])blocks, offset, this.driverContext);
                    offset += aggBlockCounts[i];
                }
                this.output = new Page((Block[])blocks);
                success = true;
                if (success || blocks == null) break block5;
            }
            catch (Throwable throwable) {
                if (!success && blocks != null) {
                    Releasables.closeExpectNoException(blocks);
                }
                this.aggregationFinishNanos += System.nanoTime() - start;
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable[])blocks);
        }
        this.aggregationFinishNanos += System.nanoTime() - start;
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.output == null;
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> {
            if (this.output != null) {
                Releasables.closeExpectNoException(() -> this.output.releaseBlocks());
            }
        }, Releasables.wrap(this.aggregators)});
    }

    private static void checkState(boolean condition, String msg) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static void checkNonEmpty(List<?> list) {
        if (list.size() < 1) {
            throw new IllegalArgumentException("empty list");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("aggregators=").append(this.aggregators).append("]");
        return sb.toString();
    }

    @Override
    public Operator.Status status() {
        return new Status(this.aggregationNanos, this.aggregationFinishNanos, this.pagesProcessed);
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "agg", Status::new);
        private final long aggregationNanos;
        private final Long aggregationFinishNanos;
        private final int pagesProcessed;

        public Status(long aggregationNanos, long aggregationFinishNanos, int pagesProcessed) {
            this.aggregationNanos = aggregationNanos;
            this.aggregationFinishNanos = aggregationFinishNanos;
            this.pagesProcessed = pagesProcessed;
        }

        protected Status(StreamInput in) throws IOException {
            this.aggregationNanos = in.readVLong();
            this.aggregationFinishNanos = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_AGGREGATION_OPERATOR_STATUS_FINISH_NANOS) ? in.readOptionalVLong() : null;
            this.pagesProcessed = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.aggregationNanos);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_AGGREGATION_OPERATOR_STATUS_FINISH_NANOS)) {
                out.writeOptionalVLong(this.aggregationFinishNanos);
            }
            out.writeVInt(this.pagesProcessed);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public long aggregationNanos() {
            return this.aggregationNanos;
        }

        public long aggregationFinishNanos() {
            return this.aggregationFinishNanos;
        }

        public int pagesProcessed() {
            return this.pagesProcessed;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("aggregation_nanos", this.aggregationNanos);
            if (builder.humanReadable()) {
                builder.field("aggregation_time", (Object)TimeValue.timeValueNanos((long)this.aggregationNanos));
            }
            builder.field("aggregation_finish_nanos", this.aggregationFinishNanos);
            if (builder.humanReadable()) {
                builder.field("aggregation_finish_time", this.aggregationFinishNanos == null ? null : TimeValue.timeValueNanos((long)this.aggregationFinishNanos));
            }
            builder.field("pages_processed", this.pagesProcessed);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.aggregationNanos == status.aggregationNanos && this.pagesProcessed == status.pagesProcessed && Objects.equals(this.aggregationFinishNanos, status.aggregationFinishNanos);
        }

        public int hashCode() {
            return Objects.hash(this.aggregationNanos, this.aggregationFinishNanos, this.pagesProcessed);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_14_0;
        }
    }

    public record AggregationOperatorFactory(List<Aggregator.Factory> aggregators, AggregatorMode mode) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new AggregationOperator(this.aggregators.stream().map(x -> (Aggregator)x.apply(driverContext)).toList(), driverContext);
        }

        @Override
        public String toString() {
            return this.describe();
        }

        @Override
        public String describe() {
            return "AggregationOperator[mode = " + this.mode + ", aggs = " + this.aggregators.stream().map(Describable::describe).collect(Collectors.joining(", ")) + "]";
        }
    }
}

