/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractPageMappingToIteratorOperator
implements Operator {
    private ReleasableIterator<Page> next;
    private boolean finished = false;
    private long processNanos;
    private int pagesReceived;
    private int pagesEmitted;

    protected abstract ReleasableIterator<Page> receive(Page var1);

    public static ReleasableIterator<Page> appendBlocks(Page page, ReleasableIterator<? extends Block> toAdd) {
        return new AppendBlocksIterator(page, toAdd);
    }

    public abstract String toString();

    @Override
    public final boolean needsInput() {
        return !this.finished && (this.next == null || !this.next.hasNext());
    }

    @Override
    public final void addInput(Page page) {
        if (this.next != null) {
            assert (!this.next.hasNext()) : "has pending input page";
            this.next.close();
        }
        if (page.getPositionCount() == 0) {
            return;
        }
        this.next = new RuntimeTrackingIterator(this.receive(page));
        ++this.pagesReceived;
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && (this.next == null || !this.next.hasNext());
    }

    @Override
    public final Page getOutput() {
        if (this.next == null || !this.next.hasNext()) {
            return null;
        }
        Page ret = (Page)this.next.next();
        ++this.pagesEmitted;
        return ret;
    }

    @Override
    public final Status status() {
        return this.status(this.processNanos, this.pagesReceived, this.pagesEmitted);
    }

    protected Status status(long processNanos, int pagesReceived, int pagesEmitted) {
        return new Status(processNanos, pagesReceived, pagesEmitted);
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException(this.next);
    }

    private static class AppendBlocksIterator
    implements ReleasableIterator<Page> {
        private final Page page;
        private final ReleasableIterator<? extends Block> next;
        private int positionOffset;

        protected AppendBlocksIterator(Page page, ReleasableIterator<? extends Block> next) {
            this.page = page;
            this.next = next;
        }

        public final boolean hasNext() {
            if (this.next.hasNext()) {
                assert (this.positionOffset < this.page.getPositionCount());
                return true;
            }
            assert (this.positionOffset == this.page.getPositionCount());
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Page next() {
            Block read = (Block)this.next.next();
            int start = this.positionOffset;
            this.positionOffset += read.getPositionCount();
            if (start == 0 && read.getPositionCount() == this.page.getPositionCount()) {
                for (int b = 0; b < this.page.getBlockCount(); ++b) {
                    this.page.getBlock(b).incRef();
                }
                return this.page.appendBlock(read);
            }
            Object[] newBlocks = new Block[this.page.getBlockCount() + 1];
            newBlocks[this.page.getBlockCount()] = read;
            try {
                int[] positions = IntStream.range(start, this.positionOffset).toArray();
                for (int b = 0; b < this.page.getBlockCount(); ++b) {
                    newBlocks[b] = this.page.getBlock(b).filter(positions);
                }
                Page result = new Page((Block[])newBlocks);
                Arrays.fill(newBlocks, null);
                Page page = result;
                return page;
            }
            finally {
                Releasables.closeExpectNoException((Releasable[])newBlocks);
            }
        }

        public void close() {
            Releasable[] releasableArray = new Releasable[2];
            releasableArray[0] = this.page::releaseBlocks;
            releasableArray[1] = this.next;
            Releasables.closeExpectNoException((Releasable[])releasableArray);
        }
    }

    private class RuntimeTrackingIterator
    implements ReleasableIterator<Page> {
        private final ReleasableIterator<Page> next;

        private RuntimeTrackingIterator(ReleasableIterator<Page> next) {
            this.next = next;
        }

        public boolean hasNext() {
            return this.next.hasNext();
        }

        public Page next() {
            long start = System.nanoTime();
            Page out = (Page)this.next.next();
            AbstractPageMappingToIteratorOperator.this.processNanos += System.nanoTime() - start;
            return out;
        }

        public void close() {
            this.next.close();
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "page_mapping_to_iterator", AbstractPageMappingOperator.Status::new);
        private final long processNanos;
        private final int pagesReceived;
        private final int pagesEmitted;

        public Status(long processNanos, int pagesProcessed, int pagesEmitted) {
            this.processNanos = processNanos;
            this.pagesReceived = pagesProcessed;
            this.pagesEmitted = pagesEmitted;
        }

        protected Status(StreamInput in) throws IOException {
            this.processNanos = in.readVLong();
            this.pagesReceived = in.readVInt();
            this.pagesEmitted = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.processNanos);
            out.writeVInt(this.pagesReceived);
            out.writeVInt(this.pagesEmitted);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesReceived() {
            return this.pagesReceived;
        }

        public int pagesEmitted() {
            return this.pagesEmitted;
        }

        public long processNanos() {
            return this.processNanos;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        protected final XContentBuilder innerToXContent(XContentBuilder builder) throws IOException {
            builder.field("process_nanos", this.processNanos);
            if (builder.humanReadable()) {
                builder.field("process_time", (Object)TimeValue.timeValueNanos((long)this.processNanos));
            }
            builder.field("pages_received", this.pagesReceived);
            return builder.field("pages_emitted", this.pagesEmitted);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.processNanos == status.processNanos && this.pagesReceived == status.pagesReceived && this.pagesEmitted == status.pagesEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.processNanos, this.pagesReceived, this.pagesEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.ESQL_PAGE_MAPPING_TO_ITERATOR;
        }
    }
}

