/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneOperator;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class LuceneCountOperator
extends LuceneOperator {
    private static final int PAGE_SIZE = 1;
    private int totalHits = 0;
    private int remainingDocs;
    private final LeafCollector leafCollector;

    public LuceneCountOperator(BlockFactory blockFactory, LuceneSliceQueue sliceQueue, int limit) {
        super(blockFactory, 1, sliceQueue);
        this.remainingDocs = limit;
        this.leafCollector = new LeafCollector(){

            public void setScorer(Scorable scorer) {
            }

            public void collect(DocIdStream stream) throws IOException {
                if (LuceneCountOperator.this.remainingDocs > 0) {
                    int count = Math.min(stream.count(), LuceneCountOperator.this.remainingDocs);
                    LuceneCountOperator.this.totalHits += count;
                    LuceneCountOperator.this.remainingDocs -= count;
                }
            }

            public void collect(int doc) {
                if (LuceneCountOperator.this.remainingDocs > 0) {
                    --LuceneCountOperator.this.remainingDocs;
                    ++LuceneCountOperator.this.totalHits;
                }
            }
        };
    }

    @Override
    public boolean isFinished() {
        return this.doneCollecting || this.remainingDocs == 0;
    }

    @Override
    public void finish() {
        this.doneCollecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Page getCheckedOutput() throws IOException {
        if (this.isFinished()) {
            if ($assertionsDisabled) return null;
            if (this.remainingDocs <= 0) return null;
            throw new AssertionError(this.remainingDocs);
        }
        long start = System.nanoTime();
        try {
            Page page;
            block12: {
                LuceneOperator.LuceneScorer scorer = this.getCurrentOrLoadNextScorer();
                if (scorer == null) {
                    this.remainingDocs = 0;
                } else {
                    LeafReaderContext leafReaderContext;
                    Weight weight = scorer.weight();
                    int leafCount = weight.count(leafReaderContext = scorer.leafReaderContext());
                    if (leafCount != -1) {
                        if (scorer.position() == 0) {
                            int count = Math.min(leafCount, this.remainingDocs);
                            this.totalHits += count;
                            this.remainingDocs -= count;
                        }
                        scorer.markAsDone();
                    } else {
                        scorer.scoreNextRange(this.leafCollector, leafReaderContext.reader().getLiveDocs(), this.remainingDocs);
                    }
                }
                page = null;
                if (this.remainingDocs <= 0 && this.pagesEmitted == 0) {
                    ++this.pagesEmitted;
                    LongBlock count = null;
                    BooleanBlock seen = null;
                    try {
                        count = this.blockFactory.newConstantLongBlockWith(this.totalHits, 1);
                        seen = this.blockFactory.newConstantBooleanBlockWith(true, 1);
                        page = new Page(1, count, seen);
                        if (page != null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (page != null) throw throwable;
                        Releasables.closeExpectNoException((Releasable[])new Releasable[]{count, seen});
                        throw throwable;
                    }
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{count, seen});
                }
            }
            Page page2 = page;
            return page2;
        }
        finally {
            this.processingNanos += System.nanoTime() - start;
        }
    }

    @Override
    protected void describe(StringBuilder sb) {
        sb.append(", remainingDocs=").append(this.remainingDocs);
    }

    public static class Factory
    extends LuceneOperator.Factory {
        public Factory(List<? extends ShardContext> contexts, Function<ShardContext, Query> queryFunction, DataPartitioning dataPartitioning, int taskConcurrency, int limit) {
            super(contexts, queryFunction, dataPartitioning, taskConcurrency, limit, ScoreMode.COMPLETE_NO_SCORES);
        }

        @Override
        public SourceOperator get(DriverContext driverContext) {
            return new LuceneCountOperator(driverContext.blockFactory(), this.sliceQueue, this.limit);
        }

        @Override
        public String describe() {
            return "LuceneCountOperator[dataPartitioning = " + this.dataPartitioning + ", limit = " + this.limit + "]";
        }
    }
}

