/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleLookup;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.DoubleVectorBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

public final class DoubleBigArrayVector
extends AbstractVector
implements DoubleVector,
Releasable {
    private static final long BASE_RAM_BYTES_USED = 0L;
    private final DoubleArray values;

    public DoubleBigArrayVector(DoubleArray values, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.values = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DoubleBigArrayVector readArrayVector(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        DoubleArray values = blockFactory.bigArrays().newDoubleArray((long)positions, false);
        boolean success = false;
        try {
            values.fillWith(in);
            DoubleBigArrayVector vector = new DoubleBigArrayVector(values, positions, blockFactory);
            blockFactory.adjustBreaker(vector.ramBytesUsed() - RamUsageEstimator.sizeOf((Accountable)values));
            success = true;
            DoubleBigArrayVector doubleBigArrayVector = vector;
            return doubleBigArrayVector;
        }
        finally {
            if (!success) {
                values.close();
            }
        }
    }

    void writeArrayVector(int positions, StreamOutput out) throws IOException {
        this.values.writeTo(out);
    }

    @Override
    public DoubleBlock asBlock() {
        return new DoubleVectorBlock(this);
    }

    @Override
    public double getDouble(int position) {
        return this.values.get((long)position);
    }

    @Override
    public ElementType elementType() {
        return ElementType.DOUBLE;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public long ramBytesUsed() {
        return 0L + RamUsageEstimator.sizeOf((Accountable)this.values);
    }

    @Override
    public DoubleVector filter(int ... positions) {
        BlockFactory blockFactory = this.blockFactory();
        DoubleArray filtered = blockFactory.bigArrays().newDoubleArray((long)positions.length);
        for (int i = 0; i < positions.length; ++i) {
            filtered.set((long)i, this.values.get((long)positions[i]));
        }
        return new DoubleBigArrayVector(filtered, positions.length, blockFactory);
    }

    @Override
    public DoubleBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new DoubleVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new DoubleVectorBlock(this);
            }
            return (DoubleBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (DoubleBlock.Builder builder = this.blockFactory().newDoubleBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendDouble(this.getDouble(p));
                    continue;
                }
                builder.appendNull();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    public ReleasableIterator<DoubleBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new DoubleLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public void closeInternal() {
        this.values.close();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DoubleVector) {
            DoubleVector that = (DoubleVector)obj;
            return DoubleVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return DoubleVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", values=" + this.values + "]";
    }
}

