/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class BytesRefVectorBlock
extends AbstractVectorBlock
implements BytesRefBlock {
    private final BytesRefVector vector;

    BytesRefVectorBlock(BytesRefVector vector) {
        this.vector = vector;
    }

    @Override
    public BytesRefVector asVector() {
        return this.vector;
    }

    @Override
    public OrdinalBytesRefBlock asOrdinals() {
        OrdinalBytesRefVector ordinals = this.vector.asOrdinals();
        if (ordinals != null) {
            return ordinals.asBlock();
        }
        return null;
    }

    @Override
    public BytesRef getBytesRef(int valueIndex, BytesRef dest) {
        return this.vector.getBytesRef(valueIndex, dest);
    }

    @Override
    public int getPositionCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public BytesRefBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    @Override
    public BytesRefBlock keepMask(BooleanVector mask) {
        return this.vector.keepMask(mask);
    }

    @Override
    public ReleasableIterator<? extends BytesRefBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return this.vector.lookup(positions, targetBlockSize);
    }

    @Override
    public BytesRefBlock expand() {
        this.incRef();
        return this;
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BytesRefBlock) {
            BytesRefBlock that = (BytesRefBlock)obj;
            return BytesRefBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BytesRefBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public void closeInternal() {
        assert (!this.vector.isReleased()) : "can't release block [" + this + "] containing already released vector";
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }
}

