/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVectorBlock;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.ToMask;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

public final class BooleanVectorBlock
extends AbstractVectorBlock
implements BooleanBlock {
    private final BooleanVector vector;

    BooleanVectorBlock(BooleanVector vector) {
        this.vector = vector;
    }

    @Override
    public BooleanVector asVector() {
        return this.vector;
    }

    @Override
    public ToMask toMask() {
        this.vector.incRef();
        return new ToMask(this.vector, false);
    }

    @Override
    public boolean getBoolean(int valueIndex) {
        return this.vector.getBoolean(valueIndex);
    }

    @Override
    public int getPositionCount() {
        return this.vector.getPositionCount();
    }

    @Override
    public ElementType elementType() {
        return this.vector.elementType();
    }

    @Override
    public BooleanBlock filter(int ... positions) {
        return this.vector.filter(positions).asBlock();
    }

    @Override
    public BooleanBlock keepMask(BooleanVector mask) {
        return this.vector.keepMask(mask);
    }

    @Override
    public ReleasableIterator<? extends BooleanBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return this.vector.lookup(positions, targetBlockSize);
    }

    @Override
    public BooleanBlock expand() {
        this.incRef();
        return this;
    }

    public long ramBytesUsed() {
        return this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BooleanBlock) {
            BooleanBlock that = (BooleanBlock)obj;
            return BooleanBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return BooleanBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[vector=" + this.vector + "]";
    }

    @Override
    public void closeInternal() {
        assert (!this.vector.isReleased()) : "can't release block [" + this + "] containing already released vector";
        Releasables.closeExpectNoException((Releasable)this.vector);
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }
}

