/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;

class ValuesFloatAggregator {
    ValuesFloatAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, float v) {
        state.values.add((long)Float.floatToIntBits(v));
    }

    public static void combineIntermediate(SingleState state, FloatBlock values) {
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesFloatAggregator.combine(state, values.getFloat(i));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, float v) {
        state.values.add((long)groupId << 32 | (long)Float.floatToIntBits(v) & 0xFFFFFFFFL);
    }

    public static void combineIntermediate(GroupingState state, int groupId, FloatBlock values, int valuesPosition) {
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesFloatAggregator.combine(state, groupId, values.getFloat(i));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        int id = 0;
        while ((long)id < state.values.size()) {
            long both = state.values.get((long)id);
            int group = (int)(both >>> 32);
            if (group == statePosition) {
                float value = Float.intBitsToFloat((int)both);
                ValuesFloatAggregator.combine(current, currentGroupId, value);
            }
            ++id;
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements Releasable {
        private final LongHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            if (this.values.size() == 1L) {
                return blockFactory.newConstantFloatBlockWith(Float.intBitsToFloat((int)this.values.get(0L)), 1);
            }
            try (FloatBlock.Builder builder = blockFactory.newFloatBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendFloat(Float.intBitsToFloat((int)this.values.get((long)id)));
                    ++id;
                }
                builder.endPositionEntry();
                FloatBlock floatBlock = builder.build();
                return floatBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements Releasable {
        private final LongHash values;

        private GroupingState(BigArrays bigArrays) {
            this.values = new LongHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            try (FloatBlock.Builder builder = blockFactory.newFloatBlockBuilder(selected.getPositionCount());){
                block13: for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int selectedGroup = selected.getInt(s);
                    int count = 0;
                    float first = 0.0f;
                    int id = 0;
                    while ((long)id < this.values.size()) {
                        long both = this.values.get((long)id);
                        int group = (int)(both >>> 32);
                        if (group == selectedGroup) {
                            float value = Float.intBitsToFloat((int)both);
                            switch (count) {
                                case 0: {
                                    first = value;
                                    break;
                                }
                                case 1: {
                                    builder.beginPositionEntry();
                                    builder.appendFloat(first);
                                    builder.appendFloat(value);
                                    break;
                                }
                                default: {
                                    builder.appendFloat(value);
                                }
                            }
                            ++count;
                        }
                        ++id;
                    }
                    switch (count) {
                        case 0: {
                            builder.appendNull();
                            continue block13;
                        }
                        case 1: {
                            builder.appendFloat(first);
                            continue block13;
                        }
                        default: {
                            builder.endPositionEntry();
                        }
                    }
                }
                FloatBlock floatBlock = builder.build();
                return floatBlock;
            }
        }

        void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            this.values.close();
        }
    }
}

