/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ValuesBytesRefAggregator {
    ValuesBytesRefAggregator() {
    }

    public static SingleState initSingle(BigArrays bigArrays) {
        return new SingleState(bigArrays);
    }

    public static void combine(SingleState state, BytesRef v) {
        state.values.add(v);
    }

    public static void combineIntermediate(SingleState state, BytesRefBlock values) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(0);
        int end = start + values.getValueCount(0);
        for (int i = start; i < end; ++i) {
            ValuesBytesRefAggregator.combine(state, values.getBytesRef(i, scratch));
        }
    }

    public static Block evaluateFinal(SingleState state, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory());
    }

    public static GroupingState initGrouping(BigArrays bigArrays) {
        return new GroupingState(bigArrays);
    }

    public static void combine(GroupingState state, int groupId, BytesRef v) {
        state.values.add((long)groupId, BlockHash.hashOrdToGroup(state.bytes.add(v)));
    }

    public static void combineIntermediate(GroupingState state, int groupId, BytesRefBlock values, int valuesPosition) {
        BytesRef scratch = new BytesRef();
        int start = values.getFirstValueIndex(valuesPosition);
        int end = start + values.getValueCount(valuesPosition);
        for (int i = start; i < end; ++i) {
            ValuesBytesRefAggregator.combine(state, groupId, values.getBytesRef(i, scratch));
        }
    }

    public static void combineStates(GroupingState current, int currentGroupId, GroupingState state, int statePosition) {
        BytesRef scratch = new BytesRef();
        int id = 0;
        while ((long)id < state.values.size()) {
            if (state.values.getKey1((long)id) == (long)statePosition) {
                long value = state.values.getKey2((long)id);
                ValuesBytesRefAggregator.combine(current, currentGroupId, state.bytes.get(value, scratch));
            }
            ++id;
        }
    }

    public static Block evaluateFinal(GroupingState state, IntVector selected, DriverContext driverContext) {
        return state.toBlock(driverContext.blockFactory(), selected);
    }

    public static class SingleState
    implements Releasable {
        private final BytesRefHash values;

        private SingleState(BigArrays bigArrays) {
            this.values = new BytesRefHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory());
        }

        Block toBlock(BlockFactory blockFactory) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(1);
            }
            BytesRef scratch = new BytesRef();
            if (this.values.size() == 1L) {
                return blockFactory.newConstantBytesRefBlockWith(BytesRef.deepCopyOf((BytesRef)this.values.get(0L, scratch)), 1);
            }
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder((int)this.values.size());){
                builder.beginPositionEntry();
                int id = 0;
                while ((long)id < this.values.size()) {
                    builder.appendBytesRef(this.values.get((long)id, scratch));
                    ++id;
                }
                builder.endPositionEntry();
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        public void close() {
            this.values.close();
        }
    }

    public static class GroupingState
    implements Releasable {
        private final LongLongHash values;
        private final BytesRefHash bytes;

        private GroupingState(BigArrays bigArrays) {
            this.values = new LongLongHash(1L, bigArrays);
            this.bytes = new BytesRefHash(1L, bigArrays);
        }

        void toIntermediate(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
            blocks[offset] = this.toBlock(driverContext.blockFactory(), selected);
        }

        Block toBlock(BlockFactory blockFactory, IntVector selected) {
            if (this.values.size() == 0L) {
                return blockFactory.newConstantNullBlock(selected.getPositionCount());
            }
            BytesRef scratch = new BytesRef();
            try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
                block13: for (int s = 0; s < selected.getPositionCount(); ++s) {
                    int selectedGroup = selected.getInt(s);
                    int count = 0;
                    long first = 0L;
                    int id = 0;
                    while ((long)id < this.values.size()) {
                        if (this.values.getKey1((long)id) == (long)selectedGroup) {
                            long value = this.values.getKey2((long)id);
                            switch (count) {
                                case 0: {
                                    first = value;
                                    break;
                                }
                                case 1: {
                                    builder.beginPositionEntry();
                                    builder.appendBytesRef(this.bytes.get(first, scratch));
                                    builder.appendBytesRef(this.bytes.get(value, scratch));
                                    break;
                                }
                                default: {
                                    builder.appendBytesRef(this.bytes.get(value, scratch));
                                }
                            }
                            ++count;
                        }
                        ++id;
                    }
                    switch (count) {
                        case 0: {
                            builder.appendNull();
                            continue block13;
                        }
                        case 1: {
                            builder.appendBytesRef(this.bytes.get(first, scratch));
                            continue block13;
                        }
                        default: {
                            builder.endPositionEntry();
                        }
                    }
                }
                BytesRefBlock bytesRefBlock = builder.build();
                return bytesRefBlock;
            }
        }

        void enableGroupIdTracking(SeenGroupIds seen) {
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.values, this.bytes});
        }
    }
}

