/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.TopIpAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIpGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIpAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final List<Integer> channels;
    private final int limit;
    private final boolean ascending;

    public TopIpAggregatorFunctionSupplier(List<Integer> channels, int limit, boolean ascending) {
        this.channels = channels;
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public TopIpAggregatorFunction aggregator(DriverContext driverContext) {
        return TopIpAggregatorFunction.create(driverContext, this.channels, this.limit, this.ascending);
    }

    @Override
    public TopIpGroupingAggregatorFunction groupingAggregator(DriverContext driverContext) {
        return TopIpGroupingAggregatorFunction.create(this.channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of ips";
    }
}

