/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.RateLongAggregator;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class RateLongGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.LONG), new IntermediateStateDesc("resets", ElementType.DOUBLE));
    private final RateLongAggregator.LongRateGroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final long unitInMillis;

    public RateLongGroupingAggregatorFunction(List<Integer> channels, RateLongAggregator.LongRateGroupingState state, DriverContext driverContext, long unitInMillis) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.unitInMillis = unitInMillis;
    }

    public static RateLongGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, long unitInMillis) {
        return new RateLongGroupingAggregatorFunction(channels, RateLongAggregator.initGrouping(driverContext, unitInMillis), driverContext, unitInMillis);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessPage(SeenGroupIds seenGroupIds, Page page) {
        final LongBlock valuesBlock = (LongBlock)page.getBlock(this.channels.get(0));
        final LongVector valuesVector = valuesBlock.asVector();
        LongBlock timestampsBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final LongVector timestampsVector = timestampsBlock.asVector();
        if (timestampsVector == null) {
            throw new IllegalStateException("expected @timestamp vector; but got a block");
        }
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntBlock groupIds) {
                    RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock, timestampsVector);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntBlock groupIds) {
                RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                RateLongGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector, timestampsVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntVector groups, LongBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                RateLongAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getLong(v));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, LongVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuePosition = groupPosition + positionOffset;
            RateLongAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getLong(valuePosition));
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongBlock values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    RateLongAggregator.combine(this.state, groupId, timestamps.getLong(v), values.getLong(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBlock groups, LongVector values, LongVector timestamps) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuePosition = groupPosition + positionOffset;
                RateLongAggregator.combine(this.state, groupId, timestamps.getLong(valuePosition), values.getLong(valuePosition));
            }
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock values = (LongBlock)valuesUncast;
        Object resetsUncast = page.getBlock(this.channels.get(2));
        if (resetsUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector resets = ((DoubleBlock)resetsUncast).asVector();
        assert (timestamps.getPositionCount() == values.getPositionCount() && timestamps.getPositionCount() == resets.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            RateLongAggregator.combineIntermediate(this.state, groupId, timestamps, values, resets.getDouble(groupPosition + positionOffset), groupPosition + positionOffset);
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + this.getClass() + "; got " + input.getClass());
        }
        RateLongAggregator.LongRateGroupingState inState = ((RateLongGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        RateLongAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, DriverContext driverContext) {
        blocks[offset] = RateLongAggregator.evaluateFinal(this.state, selected, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

