/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;

final class SyntheticSourceLicenseService {
    private static final String MAPPINGS_FEATURE_FAMILY = "mappings";
    public static final Setting<Boolean> FALLBACK_SETTING = Setting.boolSetting((String)"xpack.mapping.synthetic_source_fallback_to_stored_source", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final LicensedFeature.Momentary SYNTHETIC_SOURCE_FEATURE = LicensedFeature.momentary((String)"mappings", (String)"synthetic-source", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private XPackLicenseState licenseState;
    private volatile boolean syntheticSourceFallback;

    SyntheticSourceLicenseService(Settings settings) {
        this.syntheticSourceFallback = (Boolean)FALLBACK_SETTING.get(settings);
    }

    public boolean fallbackToStoredSource(boolean isTemplateValidation) {
        if (this.syntheticSourceFallback) {
            return true;
        }
        if (isTemplateValidation) {
            return !SYNTHETIC_SOURCE_FEATURE.checkWithoutTracking(this.licenseState);
        }
        return !SYNTHETIC_SOURCE_FEATURE.check(this.licenseState);
    }

    void setSyntheticSourceFallback(boolean syntheticSourceFallback) {
        this.syntheticSourceFallback = syntheticSourceFallback;
    }

    void setLicenseState(XPackLicenseState licenseState) {
        this.licenseState = licenseState;
    }
}

