/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.xpack.logsdb.SyntheticSourceLicenseService;

final class SyntheticSourceIndexSettingsProvider
implements IndexSettingProvider {
    private static final Logger LOGGER = LogManager.getLogger(SyntheticSourceIndexSettingsProvider.class);
    private final SyntheticSourceLicenseService syntheticSourceLicenseService;
    private final CheckedFunction<IndexMetadata, MapperService, IOException> mapperServiceFactory;

    SyntheticSourceIndexSettingsProvider(SyntheticSourceLicenseService syntheticSourceLicenseService, CheckedFunction<IndexMetadata, MapperService, IOException> mapperServiceFactory) {
        this.syntheticSourceLicenseService = syntheticSourceLicenseService;
        this.mapperServiceFactory = mapperServiceFactory;
    }

    public Settings getAdditionalIndexSettings(String indexName, String dataStreamName, IndexMode templateIndexMode, Metadata metadata, Instant resolvedAt, Settings indexTemplateAndCreateRequestSettings, List<CompressedXContent> combinedTemplateMappings) {
        boolean isTemplateValidation = "validate-index-name".equals(indexName);
        if (this.newIndexHasSyntheticSourceUsage(indexName, templateIndexMode, indexTemplateAndCreateRequestSettings, combinedTemplateMappings) && this.syntheticSourceLicenseService.fallbackToStoredSource(isTemplateValidation)) {
            LOGGER.debug("creation of index [{}] with synthetic source without it being allowed", (Object)indexName);
        }
        return Settings.EMPTY;
    }

    boolean newIndexHasSyntheticSourceUsage(String indexName, IndexMode templateIndexMode, Settings indexTemplateAndCreateRequestSettings, List<CompressedXContent> combinedTemplateMappings) {
        boolean bl;
        block10: {
            if ("validate-index-name".equals(indexName)) {
                return false;
            }
            IndexMetadata tmpIndexMetadata = this.buildIndexMetadataForMapperService(indexName, templateIndexMode, indexTemplateAndCreateRequestSettings);
            MapperService mapperService = (MapperService)this.mapperServiceFactory.apply((Object)tmpIndexMetadata);
            try {
                if (combinedTemplateMappings == null || combinedTemplateMappings.isEmpty()) {
                    combinedTemplateMappings = List.of(new CompressedXContent("{}"));
                }
                mapperService.merge("_doc", combinedTemplateMappings, MapperService.MergeReason.INDEX_TEMPLATE);
                bl = mapperService.documentMapper().sourceMapper().isSynthetic();
                if (mapperService == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (mapperService != null) {
                        try {
                            mapperService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AssertionError | Exception e) {
                    LOGGER.info(() -> Strings.format((String)"unable to create mapper service for index [%s]", (Object[])new Object[]{indexName}), (Throwable)e);
                    return false;
                }
            }
            mapperService.close();
        }
        return bl;
    }

    private IndexMetadata buildIndexMetadataForMapperService(String indexName, IndexMode templateIndexMode, Settings indexTemplateAndCreateRequestSettings) {
        IndexMetadata.Builder tmpIndexMetadata = IndexMetadata.builder((String)indexName);
        int dummyPartitionSize = (Integer)IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(indexTemplateAndCreateRequestSettings);
        int dummyShards = indexTemplateAndCreateRequestSettings.getAsInt("index.number_of_shards", Integer.valueOf(dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1));
        int shardReplicas = indexTemplateAndCreateRequestSettings.getAsInt("index.number_of_replicas", Integer.valueOf(0));
        Settings.Builder finalResolvedSettings = Settings.builder().put("index.version.created", (VersionId)IndexVersion.current()).put(indexTemplateAndCreateRequestSettings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", shardReplicas).put("index.uuid", UUIDs.randomBase64UUID());
        if (templateIndexMode == IndexMode.TIME_SERIES) {
            finalResolvedSettings.put(IndexSettings.MODE.getKey(), (Enum)IndexMode.TIME_SERIES);
            finalResolvedSettings.putList(IndexMetadata.INDEX_ROUTING_PATH.getKey(), List.of("path"));
        }
        tmpIndexMetadata.settings(finalResolvedSettings);
        return tmpIndexMetadata.build();
    }
}

