/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;

final class LogsdbIndexModeSettingsProvider
implements IndexSettingProvider {
    static final Setting<Boolean> CLUSTER_LOGSDB_ENABLED = Setting.boolSetting((String)"cluster.logsdb.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private static final String LOGS_PATTERN = "logs-*-*";
    private volatile boolean isLogsdbEnabled;

    LogsdbIndexModeSettingsProvider(Settings settings) {
        this.isLogsdbEnabled = (Boolean)CLUSTER_LOGSDB_ENABLED.get(settings);
    }

    void updateClusterIndexModeLogsdbEnabled(boolean isLogsdbEnabled) {
        this.isLogsdbEnabled = isLogsdbEnabled;
    }

    public Settings getAdditionalIndexSettings(String indexName, String dataStreamName, IndexMode templateIndexMode, Metadata metadata, Instant resolvedAt, Settings settings, List<CompressedXContent> combinedTemplateMappings) {
        if (!this.isLogsdbEnabled || dataStreamName == null) {
            return Settings.EMPTY;
        }
        IndexMode indexMode = this.resolveIndexMode(settings.get(IndexSettings.MODE.getKey()));
        if (indexMode != null) {
            return Settings.EMPTY;
        }
        if (LogsdbIndexModeSettingsProvider.matchesLogsPattern(dataStreamName)) {
            return Settings.builder().put("index.mode", IndexMode.LOGSDB.getName()).build();
        }
        return Settings.EMPTY;
    }

    private static boolean matchesLogsPattern(String name) {
        return Regex.simpleMatch((String)LOGS_PATTERN, (String)name);
    }

    private IndexMode resolveIndexMode(String mode) {
        return mode != null ? Enum.valueOf(IndexMode.class, mode.toUpperCase(Locale.ROOT)) : null;
    }
}

