/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.logsdb.LogsdbIndexModeSettingsProvider;
import org.elasticsearch.xpack.logsdb.SyntheticSourceIndexSettingsProvider;
import org.elasticsearch.xpack.logsdb.SyntheticSourceLicenseService;

public class LogsDBPlugin
extends Plugin {
    private final Settings settings;
    private final SyntheticSourceLicenseService licenseService;
    private final LogsdbIndexModeSettingsProvider logsdbIndexModeSettingsProvider;

    public LogsDBPlugin(Settings settings) {
        this.settings = settings;
        this.licenseService = new SyntheticSourceLicenseService(settings);
        this.logsdbIndexModeSettingsProvider = new LogsdbIndexModeSettingsProvider(settings);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.licenseService.setLicenseState(XPackPlugin.getSharedLicenseState());
        ClusterSettings clusterSettings = services.clusterService().getClusterSettings();
        clusterSettings.addSettingsUpdateConsumer(SyntheticSourceLicenseService.FALLBACK_SETTING, this.licenseService::setSyntheticSourceFallback);
        clusterSettings.addSettingsUpdateConsumer(LogsdbIndexModeSettingsProvider.CLUSTER_LOGSDB_ENABLED, this.logsdbIndexModeSettingsProvider::updateClusterIndexModeLogsdbEnabled);
        return super.createComponents(services);
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders(IndexSettingProvider.Parameters parameters) {
        if (DiscoveryNode.isStateless((Settings)this.settings)) {
            return List.of(this.logsdbIndexModeSettingsProvider);
        }
        return List.of(new SyntheticSourceIndexSettingsProvider(this.licenseService, (CheckedFunction<IndexMetadata, MapperService, IOException>)parameters.mapperServiceFactory()), this.logsdbIndexModeSettingsProvider);
    }

    public List<Setting<?>> getSettings() {
        return List.of(SyntheticSourceLicenseService.FALLBACK_SETTING, LogsdbIndexModeSettingsProvider.CLUSTER_LOGSDB_ENABLED);
    }
}

